/*
 * Decompiled with CFR 0.152.
 */
package waffle.util;

public abstract class Base64 {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static String encode(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder((int)Math.ceil((double)n2 / 3.0) * 4);
        int n3 = n2 % 3;
        n2 -= n3;
        int n4 = 0;
        while (n4 < n2) {
            n = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
            stringBuilder.append(ALPHABET.charAt(n >>> 18));
            stringBuilder.append(ALPHABET.charAt(n >>> 12 & 0x3F));
            stringBuilder.append(ALPHABET.charAt(n >>> 6 & 0x3F));
            stringBuilder.append(ALPHABET.charAt(n & 0x3F));
        }
        if (n3 == 0) {
            return stringBuilder.toString();
        }
        if (n3 == 1) {
            n = (byArray[n4] & 0xFF) << 4;
            stringBuilder.append(ALPHABET.charAt(n >>> 6));
            stringBuilder.append(ALPHABET.charAt(n & 0x3F));
            stringBuilder.append("==");
            return stringBuilder.toString();
        }
        n = ((byArray[n4++] & 0xFF) << 8 | byArray[n4] & 0xFF) << 2;
        stringBuilder.append(ALPHABET.charAt(n >>> 12));
        stringBuilder.append(ALPHABET.charAt(n >>> 6 & 0x3F));
        stringBuilder.append(ALPHABET.charAt(n & 0x3F));
        stringBuilder.append("=");
        return stringBuilder.toString();
    }

    public static byte[] decode(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        int n2 = string.charAt(n - 2) == '=' ? 2 : (string.charAt(n - 1) == '=' ? 1 : 0);
        int n3 = n * 3 / 4 - n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            int n6 = (ALPHABET.indexOf(string.charAt(n4++)) & 0xFF) << 18 | (ALPHABET.indexOf(string.charAt(n4++)) & 0xFF) << 12 | (ALPHABET.indexOf(string.charAt(n4++)) & 0xFF) << 6 | ALPHABET.indexOf(string.charAt(n4++)) & 0xFF;
            byArray[n5++] = (byte)(n6 >>> 16);
            if (n5 < n3) {
                byArray[n5++] = (byte)(n6 >>> 8 & 0xFF);
            }
            if (n5 >= n3) continue;
            byArray[n5++] = (byte)(n6 & 0xFF);
        }
        return byArray;
    }
}

