/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet.spi;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.spi.BasicSecurityFilterProvider;
import waffle.servlet.spi.NegotiateSecurityFilterProvider;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.util.AuthorizationHeader;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;

public class SecurityFilterProviderCollection {
    private Logger _log = LoggerFactory.getLogger(SecurityFilterProviderCollection.class);
    private List<SecurityFilterProvider> _providers = new ArrayList<SecurityFilterProvider>();

    public SecurityFilterProviderCollection(SecurityFilterProvider[] securityFilterProviderArray) {
        for (SecurityFilterProvider securityFilterProvider : securityFilterProviderArray) {
            this._log.info("using '" + securityFilterProvider.getClass().getName() + "'");
            this._providers.add(securityFilterProvider);
        }
    }

    public SecurityFilterProviderCollection(String[] stringArray, IWindowsAuthProvider iWindowsAuthProvider) {
        for (String string : stringArray) {
            string = string.trim();
            this._log.info("loading '" + string + "'");
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(IWindowsAuthProvider.class);
                SecurityFilterProvider securityFilterProvider = (SecurityFilterProvider)constructor.newInstance(iWindowsAuthProvider);
                this._providers.add(securityFilterProvider);
            }
            catch (Exception exception) {
                this._log.error("error loading '" + string + "': " + exception.getMessage());
                throw new RuntimeException(exception);
            }
        }
    }

    public SecurityFilterProviderCollection(IWindowsAuthProvider iWindowsAuthProvider) {
        this._providers.add(new NegotiateSecurityFilterProvider(iWindowsAuthProvider));
        this._providers.add(new BasicSecurityFilterProvider(iWindowsAuthProvider));
    }

    public boolean isSecurityPackageSupported(String string) {
        return this.get(string) != null;
    }

    private SecurityFilterProvider get(String string) {
        for (SecurityFilterProvider securityFilterProvider : this._providers) {
            if (!securityFilterProvider.isSecurityPackageSupported(string)) continue;
            return securityFilterProvider;
        }
        return null;
    }

    public IWindowsIdentity doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(httpServletRequest);
        SecurityFilterProvider securityFilterProvider = this.get(authorizationHeader.getSecurityPackage());
        if (securityFilterProvider == null) {
            throw new RuntimeException("Unsupported security package: " + authorizationHeader.getSecurityPackage());
        }
        return securityFilterProvider.doFilter(httpServletRequest, httpServletResponse);
    }

    public boolean isPrincipalException(HttpServletRequest httpServletRequest) {
        for (SecurityFilterProvider securityFilterProvider : this._providers) {
            if (!securityFilterProvider.isPrincipalException(httpServletRequest)) continue;
            return true;
        }
        return false;
    }

    public void sendUnauthorized(HttpServletResponse httpServletResponse) {
        for (SecurityFilterProvider securityFilterProvider : this._providers) {
            securityFilterProvider.sendUnauthorized(httpServletResponse);
        }
    }

    public int size() {
        return this._providers.size();
    }

    public SecurityFilterProvider getByClassName(String string) throws ClassNotFoundException {
        for (SecurityFilterProvider securityFilterProvider : this._providers) {
            if (!securityFilterProvider.getClass().getName().equals(string)) continue;
            return securityFilterProvider;
        }
        throw new ClassNotFoundException(string);
    }
}

