/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet.spi;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import waffle.servlet.spi.SecurityFilterProvider;
import waffle.util.AuthorizationHeader;
import waffle.util.Base64;
import waffle.util.NtlmServletRequest;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsSecurityContext;

public class NegotiateSecurityFilterProvider
implements SecurityFilterProvider {
    private Logger _log = LoggerFactory.getLogger(NegotiateSecurityFilterProvider.class);
    private List<String> _protocols = new ArrayList<String>();
    private IWindowsAuthProvider _auth = null;

    public NegotiateSecurityFilterProvider(IWindowsAuthProvider iWindowsAuthProvider) {
        this._auth = iWindowsAuthProvider;
        this._protocols.add("Negotiate");
        this._protocols.add("NTLM");
    }

    public List<String> getProtocols() {
        return this._protocols;
    }

    public void setProtocols(List<String> list) {
        this._protocols = list;
    }

    @Override
    public void sendUnauthorized(HttpServletResponse httpServletResponse) {
        Iterator<String> iterator = this._protocols.iterator();
        while (iterator.hasNext()) {
            httpServletResponse.addHeader("WWW-Authenticate", iterator.next());
        }
    }

    @Override
    public boolean isPrincipalException(HttpServletRequest httpServletRequest) {
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(httpServletRequest);
        boolean bl = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        this._log.debug("authorization: " + authorizationHeader.toString() + ", ntlm post: " + bl);
        return bl;
    }

    @Override
    public IWindowsIdentity doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        AuthorizationHeader authorizationHeader = new AuthorizationHeader(httpServletRequest);
        boolean bl = authorizationHeader.isNtlmType1PostAuthorizationHeader();
        String string = NtlmServletRequest.getConnectionId(httpServletRequest);
        String string2 = authorizationHeader.getSecurityPackage();
        this._log.debug("security package: " + string2 + ", connection id: " + string);
        if (bl) {
            this._auth.resetSecurityToken(string);
        }
        byte[] byArray = authorizationHeader.getTokenBytes();
        this._log.debug("token buffer: " + byArray.length + " byte(s)");
        IWindowsSecurityContext iWindowsSecurityContext = this._auth.acceptSecurityToken(string, byArray, string2);
        byte[] byArray2 = iWindowsSecurityContext.getToken();
        if (byArray2 != null && byArray2.length > 0) {
            object = new String(Base64.encode(byArray2));
            this._log.debug("continue token: " + (String)object);
            httpServletResponse.addHeader("WWW-Authenticate", string2 + " " + (String)object);
        }
        this._log.debug("continue required: " + iWindowsSecurityContext.isContinue());
        if (iWindowsSecurityContext.isContinue() || bl) {
            httpServletResponse.setHeader("Connection", "keep-alive");
            httpServletResponse.setStatus(401);
            httpServletResponse.flushBuffer();
            return null;
        }
        object = iWindowsSecurityContext.getIdentity();
        iWindowsSecurityContext.dispose();
        return object;
    }

    @Override
    public boolean isSecurityPackageSupported(String string) {
        for (String string2 : this._protocols) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initParameter(String string, String string2) {
        if (string.equals("protocols")) {
            String[] stringArray;
            this._protocols = new ArrayList<String>();
            for (String string3 : stringArray = string2.split("\\s+")) {
                if ((string3 = string3.trim()).length() <= 0) continue;
                this._log.debug("init protocol: " + string3);
                if (string3.equals("Negotiate") || string3.equals("NTLM")) {
                    this._protocols.add(string3);
                    continue;
                }
                this._log.error("unsupported protocol: " + string3);
                throw new RuntimeException("Unsupported protocol: " + string3);
            }
        } else {
            throw new InvalidParameterException(string);
        }
    }
}

