/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.WindowsAccount;

public class WindowsPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private String _fqn;
    private byte[] _sid;
    private String _sidString;
    private List<String> _roles;
    private transient IWindowsIdentity _identity;
    private Map<String, WindowsAccount> _groups;

    public WindowsPrincipal(IWindowsIdentity iWindowsIdentity) {
        this(iWindowsIdentity, PrincipalFormat.fqn, PrincipalFormat.fqn);
    }

    public WindowsPrincipal(IWindowsIdentity iWindowsIdentity, PrincipalFormat principalFormat, PrincipalFormat principalFormat2) {
        this._identity = iWindowsIdentity;
        this._fqn = iWindowsIdentity.getFqn();
        this._sid = iWindowsIdentity.getSid();
        this._sidString = iWindowsIdentity.getSidString();
        this._groups = WindowsPrincipal.getGroups(iWindowsIdentity.getGroups());
        this._roles = WindowsPrincipal.getRoles(iWindowsIdentity, principalFormat, principalFormat2);
    }

    private static List<String> getRoles(IWindowsIdentity iWindowsIdentity, PrincipalFormat principalFormat, PrincipalFormat principalFormat2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(WindowsPrincipal.getPrincipalNames(iWindowsIdentity, principalFormat));
        for (IWindowsAccount iWindowsAccount : iWindowsIdentity.getGroups()) {
            arrayList.addAll(WindowsPrincipal.getRoleNames(iWindowsAccount, principalFormat2));
        }
        return arrayList;
    }

    private static Map<String, WindowsAccount> getGroups(IWindowsAccount[] iWindowsAccountArray) {
        HashMap<String, WindowsAccount> hashMap = new HashMap<String, WindowsAccount>();
        for (IWindowsAccount iWindowsAccount : iWindowsAccountArray) {
            hashMap.put(iWindowsAccount.getFqn(), new WindowsAccount(iWindowsAccount));
        }
        return hashMap;
    }

    public byte[] getSid() {
        return (byte[])this._sid.clone();
    }

    public String getSidString() {
        return this._sidString;
    }

    public Map<String, WindowsAccount> getGroups() {
        return this._groups;
    }

    private static List<String> getRoleNames(IWindowsAccount iWindowsAccount, PrincipalFormat principalFormat) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (principalFormat) {
            case fqn: {
                arrayList.add(iWindowsAccount.getFqn());
                break;
            }
            case sid: {
                arrayList.add(iWindowsAccount.getSidString());
                break;
            }
            case both: {
                arrayList.add(iWindowsAccount.getFqn());
                arrayList.add(iWindowsAccount.getSidString());
                break;
            }
        }
        return arrayList;
    }

    private static List<String> getPrincipalNames(IWindowsIdentity iWindowsIdentity, PrincipalFormat principalFormat) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (principalFormat) {
            case fqn: {
                arrayList.add(iWindowsIdentity.getFqn());
                break;
            }
            case sid: {
                arrayList.add(iWindowsIdentity.getSidString());
                break;
            }
            case both: {
                arrayList.add(iWindowsIdentity.getFqn());
                arrayList.add(iWindowsIdentity.getSidString());
                break;
            }
        }
        return arrayList;
    }

    public String getRolesString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this._roles) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public boolean hasRole(String string) {
        return this._roles.contains(string);
    }

    @Override
    public String getName() {
        return this._fqn;
    }

    public IWindowsIdentity getIdentity() {
        return this._identity;
    }
}

