/*
 * Decompiled with CFR 0.152.
 */
package waffle.servlet;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import waffle.util.WaffleInfo;

public class WaffleInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        WaffleInfo waffleInfo = new WaffleInfo();
        try {
            Document document = waffleInfo.getWaffleInfo();
            Element element = document.getDocumentElement();
            Element element2 = this.getRequestInfo(document, httpServletRequest);
            element.insertBefore(element2, element.getFirstChild());
            String[] stringArray = httpServletRequest.getParameterValues("lookup");
            if (stringArray != null) {
                for (String object2 : stringArray) {
                    element.appendChild(waffleInfo.getLookupInfo(document, object2));
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(httpServletResponse.getWriter());
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            httpServletResponse.setContentType("application/xml");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServletException((Throwable)parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new ServletException((Throwable)transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new ServletException((Throwable)transformerException);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public Element getRequestInfo(Document document, HttpServletRequest httpServletRequest) {
        Object object;
        Element element = document.createElement("request");
        Element element2 = document.createElement("AuthType");
        element2.setTextContent(httpServletRequest.getAuthType());
        element.appendChild(element2);
        Principal principal = httpServletRequest.getUserPrincipal();
        if (principal != null) {
            object = document.createElement("principal");
            object.setAttribute("class", principal.getClass().getName());
            element2 = document.createElement("name");
            element2.setTextContent(principal.getName());
            object.appendChild(element2);
            element2 = document.createElement("string");
            element2.setTextContent(((Object)principal).toString());
            object.appendChild(element2);
            element.appendChild((Node)object);
        }
        if ((object = httpServletRequest.getHeaderNames()).hasMoreElements()) {
            Element element3 = document.createElement("headers");
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                element2 = document.createElement(string);
                element2.setTextContent(httpServletRequest.getHeader(string));
                element3.appendChild(element2);
            }
            element.appendChild(element3);
        }
        return element;
    }
}

