/*
 * Decompiled with CFR 0.152.
 */
package waffle.mock.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.mockito.Mockito;

public class SimpleHttpResponse
extends HttpServletResponseWrapper {
    private int _status = 500;
    private Map<String, List<String>> _headers = new HashMap<String, List<String>>();
    private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private final ServletOutputStream out = new ServletOutputStream(){

        public void write(int n) throws IOException {
            SimpleHttpResponse.this.bytes.write(n);
        }
    };
    private final PrintWriter writer = new PrintWriter(this.bytes);

    public SimpleHttpResponse() {
        super((HttpServletResponse)Mockito.mock(HttpServletResponse.class));
    }

    public int getStatus() {
        return this._status;
    }

    public void addHeader(String string, String string2) {
        List<String> list = this._headers.get(string);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(string2);
        this._headers.put(string, list);
    }

    public void setHeader(String string, String string2) {
        List<String> list = this._headers.get(string);
        if (list == null) {
            list = new ArrayList<String>();
        } else {
            list.clear();
        }
        list.add(string2);
        this._headers.put(string, list);
    }

    public void setStatus(int n) {
        this._status = n;
    }

    public String getStatusString() {
        if (this._status == 401) {
            return "Unauthorized";
        }
        return "Unknown";
    }

    public void flushBuffer() {
        System.out.println(this._status + " " + this.getStatusString());
        for (String string : this._headers.keySet()) {
            for (String string2 : this._headers.get(string)) {
                System.out.println(string + ": " + string2);
            }
        }
    }

    public int getHeaderNamesSize() {
        return this._headers.size();
    }

    public String[] getHeaderValues(String string) {
        List<String> list = this._headers.get(string);
        return list == null ? null : list.toArray(new String[0]);
    }

    public String getHeader(String string) {
        List<String> list = this._headers.get(string);
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public void sendError(int n, String string) {
        this._status = n;
    }

    public void sendError(int n) {
        this._status = n;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public String getOutputText() {
        this.writer.flush();
        return this.bytes.toString();
    }
}

