/*
 * Decompiled with CFR 0.152.
 */
package waffle.mock.http;

import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.mockito.Mockito;
import waffle.mock.http.SimpleHttpSession;

public class SimpleHttpRequest
extends HttpServletRequestWrapper {
    private static int _remotePort_s = 0;
    private String _requestURI = null;
    private String _queryString = null;
    private String _remoteUser = null;
    private String _method = "GET";
    private String _remoteHost = null;
    private String _remoteAddr = null;
    private int _remotePort = -1;
    private Map<String, String> _headers = new HashMap<String, String>();
    private Map<String, String> _parameters = new HashMap<String, String>();
    private byte[] _content = null;
    private HttpSession _session = new SimpleHttpSession();
    private Principal _principal = null;

    public SimpleHttpRequest() {
        super((HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        this._remotePort = SimpleHttpRequest.nextRemotePort();
    }

    public static synchronized int nextRemotePort() {
        return ++_remotePort_s;
    }

    public static synchronized void resetRemotePort() {
        _remotePort_s = 0;
    }

    public void addHeader(String string, String string2) {
        this._headers.put(string, string2);
    }

    public String getHeader(String string) {
        return this._headers.get(string);
    }

    public Enumeration<String> getHeaderNames() {
        Vector<String> vector = new Vector<String>(this._headers.keySet());
        return vector.elements();
    }

    public String getMethod() {
        return this._method;
    }

    public int getContentLength() {
        return this._content == null ? -1 : this._content.length;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public void setMethod(String string) {
        this._method = string;
    }

    public void setContentLength(int n) {
        this._content = new byte[n];
    }

    public void setRemoteUser(String string) {
        this._remoteUser = string;
    }

    public String getRemoteUser() {
        return this._remoteUser;
    }

    public HttpSession getSession() {
        return this._session;
    }

    public HttpSession getSession(boolean bl) {
        if (this._session == null && bl) {
            this._session = new SimpleHttpSession();
        }
        return this._session;
    }

    public String getQueryString() {
        return this._queryString;
    }

    public void setQueryString(String string) {
        this._queryString = string;
        if (this._queryString != null) {
            for (String string2 : this._queryString.split("[&]")) {
                String[] stringArray = string2.split("=");
                String string3 = stringArray.length == 2 ? stringArray[1] : "";
                this.addParameter(stringArray[0], string3);
            }
        }
    }

    public void setRequestURI(String string) {
        this._requestURI = string;
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    public String getParameter(String string) {
        return this._parameters.get(string);
    }

    public void addParameter(String string, String string2) {
        this._parameters.put(string, string2);
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public void setRemoteHost(String string) {
        this._remoteHost = string;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public void setRemoteAddr(String string) {
        this._remoteAddr = string;
    }

    public Principal getUserPrincipal() {
        return this._principal;
    }

    public void setUserPrincipal(Principal principal) {
        this._principal = principal;
    }
}

