/*
 * Decompiled with CFR 0.152.
 */
package waffle.mock;

import java.util.ArrayList;
import java.util.List;
import waffle.mock.MockWindowsAccount;
import waffle.mock.MockWindowsImpersonationContext;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;

public class MockWindowsIdentity
implements IWindowsIdentity {
    private String _fqn;
    private List<String> _groups;

    public MockWindowsIdentity(String string, List<String> list) {
        this._fqn = string;
        this._groups = list;
    }

    @Override
    public String getFqn() {
        return this._fqn;
    }

    @Override
    public IWindowsAccount[] getGroups() {
        ArrayList<MockWindowsAccount> arrayList = new ArrayList<MockWindowsAccount>();
        for (String string : this._groups) {
            arrayList.add(new MockWindowsAccount(string));
        }
        return arrayList.toArray(new IWindowsAccount[0]);
    }

    @Override
    public byte[] getSid() {
        return new byte[0];
    }

    @Override
    public String getSidString() {
        return "S-" + this._fqn.hashCode();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isGuest() {
        return this._fqn.equals("Guest");
    }

    @Override
    public IWindowsImpersonationContext impersonate() {
        return new MockWindowsImpersonationContext();
    }
}

