/*
 * Decompiled with CFR 0.152.
 */
package waffle.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import waffle.jaas.RolePrincipal;
import waffle.jaas.UserPrincipal;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsAuthProvider;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.PrincipalFormat;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class WindowsLoginModule
implements LoginModule {
    private String _username = null;
    private boolean _debug = false;
    private Subject _subject = null;
    private CallbackHandler _callbackHandler = null;
    private IWindowsAuthProvider _auth = new WindowsAuthProviderImpl();
    private Set<Principal> _principals = null;
    private PrincipalFormat _principalFormat = PrincipalFormat.fqn;
    private PrincipalFormat _roleFormat = PrincipalFormat.fqn;
    private boolean _allowGuestLogin = true;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
        for (Map.Entry<String, ?> entry : map2.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("debug")) {
                this._debug = Boolean.parseBoolean((String)entry.getValue());
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("principalFormat")) {
                this._principalFormat = PrincipalFormat.valueOf((String)entry.getValue());
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("roleFormat")) continue;
            this._roleFormat = PrincipalFormat.valueOf((String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws LoginException {
        if (this._callbackHandler == null) {
            throw new LoginException("Missing callback to gather information from the user.");
        }
        NameCallback nameCallback = new NameCallback("user name: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        Callback[] callbackArray = new Callback[]{nameCallback, passwordCallback};
        String string = null;
        String string2 = null;
        try {
            this._callbackHandler.handle(callbackArray);
            string = nameCallback.getName();
            string2 = passwordCallback.getPassword() == null ? "" : new String(passwordCallback.getPassword());
            passwordCallback.clearPassword();
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Callback " + unsupportedCallbackException.getCallback().getClass().getName() + " not available to gather authentication information from the user.");
        }
        IWindowsIdentity iWindowsIdentity = null;
        try {
            iWindowsIdentity = this._auth.logonUser(string, string2);
        }
        catch (Exception exception) {
            throw new LoginException(exception.getMessage());
        }
        try {
            if (!this._allowGuestLogin && iWindowsIdentity.isGuest()) {
                this.debug("guest login disabled: " + iWindowsIdentity.getFqn());
                throw new LoginException("Guest login disabled");
            }
            this._principals = new LinkedHashSet<Principal>();
            this._principals.addAll(WindowsLoginModule.getUserPrincipals(iWindowsIdentity, this._principalFormat));
            if (this._roleFormat != PrincipalFormat.none) {
                for (IWindowsAccount iWindowsAccount : iWindowsIdentity.getGroups()) {
                    this._principals.addAll(WindowsLoginModule.getRolePrincipals(iWindowsAccount, this._roleFormat));
                }
            }
            this._username = iWindowsIdentity.getFqn();
            this.debug("successfully logged in " + this._username + " (" + iWindowsIdentity.getSidString() + ")");
        }
        finally {
            iWindowsIdentity.dispose();
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.logout();
    }

    @Override
    public boolean commit() throws LoginException {
        if (this._principals == null) {
            return false;
        }
        if (this._subject.isReadOnly()) {
            throw new LoginException("Subject cannot be read-only.");
        }
        Set<Principal> set = this._subject.getPrincipals();
        set.addAll(this._principals);
        this.debug("committing " + this._subject.getPrincipals().size() + " principals");
        if (this._debug) {
            for (Principal principal : set) {
                this.debug(" principal: " + principal.getName());
            }
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this._subject.isReadOnly()) {
            throw new LoginException("Subject cannot be read-only.");
        }
        this._subject.getPrincipals().clear();
        if (this._username != null) {
            this.debug("logging out " + this._username);
        }
        return true;
    }

    private void debug(String string) {
        if (this._debug) {
            System.out.println("[waffle.jaas.WindowsLoginModule] " + string);
        }
    }

    public boolean isDebug() {
        return this._debug;
    }

    public IWindowsAuthProvider getAuth() {
        return this._auth;
    }

    public void setAuth(IWindowsAuthProvider iWindowsAuthProvider) {
        this._auth = iWindowsAuthProvider;
    }

    private static List<Principal> getUserPrincipals(IWindowsIdentity iWindowsIdentity, PrincipalFormat principalFormat) {
        ArrayList<Principal> arrayList = new ArrayList<Principal>();
        switch (principalFormat) {
            case fqn: {
                arrayList.add(new UserPrincipal(iWindowsIdentity.getFqn()));
                break;
            }
            case sid: {
                arrayList.add(new UserPrincipal(iWindowsIdentity.getSidString()));
                break;
            }
            case both: {
                arrayList.add(new UserPrincipal(iWindowsIdentity.getFqn()));
                arrayList.add(new UserPrincipal(iWindowsIdentity.getSidString()));
                break;
            }
        }
        return arrayList;
    }

    private static List<Principal> getRolePrincipals(IWindowsAccount iWindowsAccount, PrincipalFormat principalFormat) {
        ArrayList<Principal> arrayList = new ArrayList<Principal>();
        switch (principalFormat) {
            case fqn: {
                arrayList.add(new RolePrincipal(iWindowsAccount.getFqn()));
                break;
            }
            case sid: {
                arrayList.add(new RolePrincipal(iWindowsAccount.getSidString()));
                break;
            }
            case both: {
                arrayList.add(new RolePrincipal(iWindowsAccount.getFqn()));
                arrayList.add(new RolePrincipal(iWindowsAccount.getSidString()));
                break;
            }
        }
        return arrayList;
    }

    public boolean isAllowGuestLogin() {
        return this._allowGuestLogin;
    }

    public void setAllowGuestLogin(boolean bl) {
        this._allowGuestLogin = bl;
    }
}

