/*
 * Decompiled with CFR 0.152.
 */
package oshi.json.software.os.impl;

import java.util.Properties;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import oshi.json.json.AbstractOshiJsonObject;
import oshi.json.json.NullAwareJsonObjectBuilder;
import oshi.json.software.os.OSProcess;
import oshi.json.util.PropertiesUtil;
import oshi.software.os.OSProcess;

public class OSProcessImpl
extends AbstractOshiJsonObject
implements OSProcess {
    private static final long serialVersionUID = 1L;
    private transient JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);
    private oshi.software.os.OSProcess osProcess;

    public OSProcessImpl(oshi.software.os.OSProcess osProcess) {
        this.osProcess = osProcess;
    }

    @Override
    public String getName() {
        return this.osProcess.getName();
    }

    @Override
    public String getPath() {
        return this.osProcess.getPath();
    }

    @Override
    public OSProcess.State getState() {
        return this.osProcess.getState();
    }

    @Override
    public int getProcessID() {
        return this.osProcess.getProcessID();
    }

    @Override
    public int getParentProcessID() {
        return this.osProcess.getParentProcessID();
    }

    @Override
    public int getThreadCount() {
        return this.osProcess.getThreadCount();
    }

    @Override
    public int getPriority() {
        return this.osProcess.getPriority();
    }

    @Override
    public long getVirtualSize() {
        return this.osProcess.getVirtualSize();
    }

    @Override
    public long getResidentSetSize() {
        return this.osProcess.getResidentSetSize();
    }

    @Override
    public long getKernelTime() {
        return this.osProcess.getKernelTime();
    }

    @Override
    public long getUserTime() {
        return this.osProcess.getUserTime();
    }

    @Override
    public long getUpTime() {
        return this.osProcess.getUpTime();
    }

    @Override
    public long getStartTime() {
        return this.osProcess.getStartTime();
    }

    @Override
    public JsonObject toJSON(Properties properties) {
        JsonObjectBuilder json = NullAwareJsonObjectBuilder.wrap(this.jsonFactory.createObjectBuilder());
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.name")) {
            json.add("name", this.getName());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.path")) {
            json.add("path", this.getPath());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.state")) {
            json.add("state", this.getState().name());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.processID")) {
            json.add("processID", this.getProcessID());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.parentProcessID")) {
            json.add("parentProcessID", this.getParentProcessID());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.threadCount")) {
            json.add("threadCount", this.getThreadCount());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.priority")) {
            json.add("priority", this.getPriority());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.virtualSize")) {
            json.add("virtualSize", this.getVirtualSize());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.residentSetSize")) {
            json.add("residentSetSize", this.getResidentSetSize());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.kernelTime")) {
            json.add("kernelTime", this.getKernelTime());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.userTime")) {
            json.add("userTime", this.getUserTime());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.upTime")) {
            json.add("upTime", this.getUpTime());
        }
        if (PropertiesUtil.getBoolean(properties, "operatingSystem.processes.startTime")) {
            json.add("startTime", this.getStartTime());
        }
        return json.build();
    }
}

