/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.unix.LibC;

public class BsdSysctlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BsdSysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed syctl call: {}, Error code: {}";

    private BsdSysctlUtil() {
    }

    public static int sysctl(String name, int def) {
        IntByReference size = new IntByReference(LibC.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != LibC.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            LOG.error("Failed sysctl call: {}, Error code: {}", (Object)name, (Object)Native.getLastError());
            return def;
        }
        return p.getInt(0L);
    }

    public static long sysctl(String name, long def) {
        IntByReference size = new IntByReference(LibC.UINT64_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != LibC.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return p.getLong(0L);
    }

    public static String sysctl(String name, String def) {
        IntByReference size = new IntByReference();
        if (0 != LibC.INSTANCE.sysctlbyname(name, null, size, null, 0)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        Memory p = new Memory((long)(size.getValue() + 1));
        if (0 != LibC.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return def;
        }
        return p.getString(0L);
    }

    public static boolean sysctl(String name, Structure struct) {
        if (0 != LibC.INSTANCE.sysctlbyname(name, struct.getPointer(), new IntByReference(struct.size()), null, 0)) {
            LOG.error(SYSCTL_FAIL, (Object)name, (Object)Native.getLastError());
            return false;
        }
        struct.read();
        return true;
    }
}

