/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.Kernel32;
import oshi.jna.platform.windows.Psapi;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.windows.WindowsFileSystem;
import oshi.software.os.windows.WindowsOSVersionInfoEx;
import oshi.software.os.windows.WindowsProcess;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsOperatingSystem.class);
    private static String processProperties = "Name,CommandLine,ExecutionState,ProcessID,ParentProcessId,ThreadCount,Priority,VirtualSize,WorkingSetSize,KernelModeTime,UserModeTime,CreationDate";
    private static WmiUtil.ValueType[] processPropertyTypes = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.DATETIME};

    public WindowsOperatingSystem() {
        this.manufacturer = "Microsoft";
        this.family = "Windows";
        this.version = new WindowsOSVersionInfoEx();
    }

    @Override
    public FileSystem getFileSystem() {
        return new WindowsFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        Map<String, List<Object>> procs = WmiUtil.selectObjectsFrom(null, "Win32_Process", processProperties, null, processPropertyTypes);
        List<OSProcess> procList = this.processMapToList(procs);
        List<OSProcess> sorted = this.processSort(procList, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        Map<String, List<Object>> procs = WmiUtil.selectObjectsFrom(null, "Win32_Process", processProperties, String.format("WHERE ProcessId=%d", pid), processPropertyTypes);
        List<OSProcess> procList = this.processMapToList(procs);
        return procList.isEmpty() ? null : procList.get(0);
    }

    private List<OSProcess> processMapToList(Map<String, List<Object>> procs) {
        long now = System.currentTimeMillis();
        ArrayList<OSProcess> procList = new ArrayList<OSProcess>();
        for (int p = 0; p < procs.get("Name").size(); ++p) {
            procList.add(new WindowsProcess((String)procs.get("Name").get(p), (String)procs.get("CommandLine").get(p), ((Long)procs.get("ExecutionState").get(p)).intValue(), ((Long)procs.get("ProcessID").get(p)).intValue(), ((Long)procs.get("ParentProcessId").get(p)).intValue(), ((Long)procs.get("ThreadCount").get(p)).intValue(), ((Long)procs.get("Priority").get(p)).intValue(), ParseUtil.parseLongOrDefault((String)procs.get("VirtualSize").get(p), 0L), ParseUtil.parseLongOrDefault((String)procs.get("WorkingSetSize").get(p), 0L), ParseUtil.parseLongOrDefault((String)procs.get("KernelModeTime").get(p), 0L) / 10000L, ParseUtil.parseLongOrDefault((String)procs.get("UserModeTime").get(p), 0L) / 10000L, (Long)procs.get("CreationDate").get(p), now));
        }
        return procList;
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public int getProcessCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ProcessCount.intValue();
    }

    @Override
    public int getThreadCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ThreadCount.intValue();
    }
}

