/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import java.util.ArrayList;
import java.util.List;
import oshi.jna.platform.linux.Libc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.solaris.SolarisFileSystem;
import oshi.software.os.unix.solaris.SolarisOSVersionInfoEx;
import oshi.software.os.unix.solaris.SolarisProcess;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

public class SolarisOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;

    public SolarisOperatingSystem() {
        this.manufacturer = "Oracle";
        this.family = "SunOS";
        this.version = new SolarisOSVersionInfoEx();
    }

    @Override
    public FileSystem getFileSystem() {
        return new SolarisFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        List<String> procList = ExecutingCommand.runNative("ps -eo s,pid,ppid,nlwp,pri,vsz,rss,etime,time,comm");
        if (procList.isEmpty() || procList.size() < 2) {
            return new OSProcess[0];
        }
        procList.remove(0);
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (String proc : procList) {
            String[] split = proc.trim().split("\\s+");
            if (split.length < 10) continue;
            String path = split[9];
            long now = System.currentTimeMillis();
            procs.add(new SolarisProcess(path.substring(path.lastIndexOf(47) + 1), path, split[0].charAt(0), ParseUtil.parseIntOrDefault(split[1], 0), ParseUtil.parseIntOrDefault(split[2], 0), ParseUtil.parseIntOrDefault(split[3], 0), ParseUtil.parseIntOrDefault(split[4], 0), ParseUtil.parseLongOrDefault(split[5], 0L), ParseUtil.parseLongOrDefault(split[6], 0L), ParseUtil.parseDHMSOrDefault(split[7], 0L), ParseUtil.parseDHMSOrDefault(split[8], 0L), now));
        }
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        List<String> procList = ExecutingCommand.runNative("ps -o s,pid,ppid,nlwp,pri,vsz,rss,etime,time,comm -p " + pid);
        if (procList.isEmpty() || procList.size() < 2) {
            return null;
        }
        String[] split = procList.get(1).trim().split("\\s+");
        if (split.length < 10) {
            return null;
        }
        String path = split[9];
        return new SolarisProcess(path.substring(path.lastIndexOf(47) + 1), path, split[0].charAt(0), pid, ParseUtil.parseIntOrDefault(split[2], 0), ParseUtil.parseIntOrDefault(split[3], 0), ParseUtil.parseIntOrDefault(split[4], 0), ParseUtil.parseLongOrDefault(split[5], 0L), ParseUtil.parseLongOrDefault(split[6], 0L), ParseUtil.parseDHMSOrDefault(split[7], 0L), ParseUtil.parseDHMSOrDefault(split[8], 0L), System.currentTimeMillis());
    }

    @Override
    public int getProcessId() {
        return Libc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcUtil.getPidFiles().length;
    }

    @Override
    public int getThreadCount() {
        List<String> threadList = ExecutingCommand.runNative("ps -eLo pid");
        if (!threadList.isEmpty()) {
            return threadList.size() - 1;
        }
        return this.getProcessCount();
    }
}

