/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.freebsd;

import oshi.software.common.AbstractProcess;
import oshi.software.os.OSProcess;

public class FreeBsdProcess
extends AbstractProcess {
    private static final long serialVersionUID = 1L;

    public FreeBsdProcess(String name, String path, char state, int processID, int parentProcessID, int threadCount, int priority, long virtualSize, long residentSetSize, long elapsedTime, long systemTime, long processTime, long now) {
        this.name = name;
        this.path = path;
        switch (state) {
            case 'R': {
                this.state = OSProcess.State.RUNNING;
                break;
            }
            case 'I': 
            case 'S': {
                this.state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': 
            case 'L': 
            case 'W': {
                this.state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                this.state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                this.state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                this.state = OSProcess.State.OTHER;
            }
        }
        this.processID = processID;
        this.parentProcessID = parentProcessID;
        this.threadCount = threadCount;
        this.priority = priority;
        this.virtualSize = virtualSize * 1024L;
        this.residentSetSize = residentSetSize * 1024L;
        this.kernelTime = systemTime;
        this.userTime = processTime - this.kernelTime;
        this.upTime = elapsedTime < 1L ? 1000L : elapsedTime * 1000L;
        this.startTime = now - this.upTime;
    }
}

