/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.freebsd;

import java.util.ArrayList;
import java.util.List;
import oshi.jna.platform.linux.Libc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.freebsd.FreeBsdFileSystem;
import oshi.software.os.unix.freebsd.FreeBsdOSVersionInfoEx;
import oshi.software.os.unix.freebsd.FreeBsdProcess;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

public class FreeBsdOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;

    public FreeBsdOperatingSystem() {
        this.manufacturer = "Unix/BSD";
        this.family = BsdSysctlUtil.sysctl("kern.ostype", "FreeBSD");
        this.version = new FreeBsdOSVersionInfoEx();
    }

    @Override
    public FileSystem getFileSystem() {
        return new FreeBsdFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        List<String> procList = ExecutingCommand.runNative("ps -awwxo state,pid,ppid,nlwp,pri,vsz,rss,etimes,systime,time,command");
        if (procList.isEmpty() || procList.size() < 2) {
            return new OSProcess[0];
        }
        procList.remove(0);
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (String proc : procList) {
            String[] split = proc.trim().split("\\s+");
            if (split.length < 11) continue;
            String path = split[10];
            long now = System.currentTimeMillis();
            procs.add(new FreeBsdProcess(path.substring(path.lastIndexOf(47) + 1), path, split[0].charAt(0), ParseUtil.parseIntOrDefault(split[1], 0), ParseUtil.parseIntOrDefault(split[2], 0), ParseUtil.parseIntOrDefault(split[3], 0), ParseUtil.parseIntOrDefault(split[4], 0), ParseUtil.parseLongOrDefault(split[5], 0L), ParseUtil.parseLongOrDefault(split[6], 0L), ParseUtil.parseLongOrDefault(split[7], 0L), ParseUtil.parseDHMSOrDefault(split[8], 0L), ParseUtil.parseDHMSOrDefault(split[9], 0L), now));
        }
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        List<String> procList = ExecutingCommand.runNative("ps -awwxo state,pid,ppid,nlwp,pri,vsz,rss,etimes,systime,time,command -p " + pid);
        if (procList.isEmpty() || procList.size() < 2) {
            return null;
        }
        String[] split = procList.get(1).trim().split("\\s+");
        if (split.length < 11) {
            return null;
        }
        String path = split[10];
        return new FreeBsdProcess(path.substring(path.lastIndexOf(47) + 1), path, split[0].charAt(0), pid, ParseUtil.parseIntOrDefault(split[2], 0), ParseUtil.parseIntOrDefault(split[3], 0), ParseUtil.parseIntOrDefault(split[4], 0), ParseUtil.parseLongOrDefault(split[5], 0L), ParseUtil.parseLongOrDefault(split[6], 0L), ParseUtil.parseLongOrDefault(split[7], 0L), ParseUtil.parseDHMSOrDefault(split[8], 0L), ParseUtil.parseDHMSOrDefault(split[9], 0L), System.currentTimeMillis());
    }

    @Override
    public int getProcessId() {
        return Libc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        List<String> procList = ExecutingCommand.runNative("ps -axo pid");
        if (!procList.isEmpty()) {
            return procList.size() - 1;
        }
        return 0;
    }

    @Override
    public int getThreadCount() {
        int threads = 0;
        for (String proc : ExecutingCommand.runNative("ps -axo nlwp")) {
            threads += ParseUtil.parseIntOrDefault(proc.trim(), 0);
        }
        return threads;
    }
}

