/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import oshi.jna.platform.mac.SystemB;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.mac.MacFileSystem;
import oshi.software.os.mac.MacOSVersionInfoEx;
import oshi.software.os.mac.MacProcess;
import oshi.util.platform.mac.SysctlUtil;

public class MacOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;
    private int maxProc = 1024;

    public MacOperatingSystem() {
        this.manufacturer = "Apple";
        this.family = System.getProperty("os.name");
        this.version = new MacOSVersionInfoEx();
        this.maxProc = SysctlUtil.sysctl("kern.maxproc", 4096);
    }

    @Override
    public FileSystem getFileSystem() {
        return new MacFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        int[] pids = new int[this.maxProc];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length) / SystemB.INT_SIZE;
        for (int i = 0; i < numberOfProcesses; ++i) {
            OSProcess proc = this.getProcess(pids[i]);
            if (proc == null) continue;
            procs.add(proc);
        }
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        String[] pathSplit;
        SystemB.ProcTaskAllInfo taskAllInfo = new SystemB.ProcTaskAllInfo();
        if (0 > SystemB.INSTANCE.proc_pidinfo(pid, 2, 0L, taskAllInfo, taskAllInfo.size())) {
            return null;
        }
        String name = null;
        String path = "";
        Memory buf = new Memory(4096L);
        if (0 < SystemB.INSTANCE.proc_pidpath(pid, (Pointer)buf, 4096) && (pathSplit = (path = buf.getString(0L).trim()).split("/")).length > 0) {
            name = pathSplit[pathSplit.length - 1];
        }
        if (taskAllInfo.ptinfo.pti_threadnum < 1) {
            return null;
        }
        if (name == null) {
            for (int t = 0; t < taskAllInfo.pbsd.pbi_comm.length; ++t) {
                if (taskAllInfo.pbsd.pbi_comm[t] != 0) continue;
                name = new String(taskAllInfo.pbsd.pbi_comm, 0, t);
                break;
            }
        }
        return new MacProcess(name, path, taskAllInfo.pbsd.pbi_status, pid, taskAllInfo.pbsd.pbi_ppid, taskAllInfo.ptinfo.pti_threadnum, taskAllInfo.ptinfo.pti_priority, taskAllInfo.ptinfo.pti_virtual_size, taskAllInfo.ptinfo.pti_resident_size, taskAllInfo.ptinfo.pti_total_system / 1000000L, taskAllInfo.ptinfo.pti_total_user / 1000000L, taskAllInfo.pbsd.pbi_start_tvsec * 1000L + taskAllInfo.pbsd.pbi_start_tvusec / 1000L, System.currentTimeMillis());
    }

    @Override
    public int getProcessId() {
        return SystemB.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return SystemB.INSTANCE.proc_listpids(1, 0, null, 0) / SystemB.INT_SIZE;
    }

    @Override
    public int getThreadCount() {
        int[] pids = new int[this.getProcessCount() + 10];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length) / SystemB.INT_SIZE;
        int numberOfThreads = 0;
        SystemB.ProcTaskInfo taskInfo = new SystemB.ProcTaskInfo();
        for (int i = 0; i < numberOfProcesses; ++i) {
            SystemB.INSTANCE.proc_pidinfo(pids[i], 4, 0L, taskInfo, taskInfo.size());
            numberOfThreads += taskInfo.pti_threadnum;
        }
        return numberOfThreads;
    }
}

