/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.common.AbstractProcess;
import oshi.software.os.OSProcess;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

public class LinuxProcess
extends AbstractProcess {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxProcess.class);
    private static long hz = 1000L;
    private static long bootTime = 0L;

    public LinuxProcess(String name, String path, char state, int processID, int parentProcessID, int threadCount, int priority, long virtualSize, long residentSetSize, long kernelTime, long userTime, long startTime, long now) {
        this.name = name;
        this.path = path;
        switch (state) {
            case 'R': {
                this.state = OSProcess.State.RUNNING;
                break;
            }
            case 'S': {
                this.state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': {
                this.state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                this.state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                this.state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                this.state = OSProcess.State.OTHER;
            }
        }
        this.processID = processID;
        this.parentProcessID = parentProcessID;
        this.threadCount = threadCount;
        this.priority = priority;
        this.virtualSize = virtualSize;
        this.residentSetSize = residentSetSize;
        this.kernelTime = kernelTime * 1000L / hz;
        this.userTime = userTime * 1000L / hz;
        this.startTime = bootTime + startTime * 1000L / hz;
        this.upTime = now - this.startTime;
    }

    private static void init() {
        File[] pids = ProcUtil.getPidFiles();
        long youngestJiffies = 0L;
        String youngestPid = "";
        for (File pid : pids) {
            long jiffies;
            String[] split;
            List<String> stat = FileUtil.readFile(String.format("/proc/%s/stat", pid.getName()));
            if (stat.isEmpty() || (split = stat.get(0).split("\\s+")).length < 22 || (jiffies = ParseUtil.parseLongOrDefault(split[21], 0L)) <= youngestJiffies) continue;
            youngestJiffies = jiffies;
            youngestPid = pid.getName();
        }
        LOG.debug("Youngest PID is {} with {} jiffies", (Object)youngestPid, (Object)youngestJiffies);
        if (youngestJiffies == 0L) {
            LOG.error("Couldn't find any running processes, which is odd since we are in a running process. Process time values are in jiffies, not milliseconds.");
            return;
        }
        float startTimeSecsSinceBoot = ProcUtil.getSystemUptimeFromProc();
        bootTime = System.currentTimeMillis() - (long)(1000.0f * startTimeSecsSinceBoot);
        String etime = ExecutingCommand.getFirstAnswer(String.format("ps -p %s -o etimes=", youngestPid));
        if (!etime.isEmpty()) {
            LOG.debug("Etime is {} seconds", (Object)etime.trim());
            startTimeSecsSinceBoot -= Float.parseFloat(etime.trim());
        }
        LOG.debug("Start time in secs: {}", (Object)Float.valueOf(startTimeSecsSinceBoot));
        if (startTimeSecsSinceBoot <= 0.0f) {
            LOG.warn("Couldn't calculate jiffies per second. Process time values are in jiffies, not milliseconds.");
            return;
        }
        hz = (long)((float)youngestJiffies / startTimeSecsSinceBoot + 0.5f);
    }

    static {
        LinuxProcess.init();
    }
}

