/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.linux.Libc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.linux.LinuxFileSystem;
import oshi.software.os.linux.LinuxOSVersionInfoEx;
import oshi.software.os.linux.LinuxProcess;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

public class LinuxOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxOperatingSystem.class);
    protected String versionId;
    protected String codeName;

    public LinuxOperatingSystem() {
        this.manufacturer = "GNU/Linux";
        this.setFamilyFromReleaseFiles();
        this.version = new LinuxOSVersionInfoEx(this.versionId, this.codeName);
    }

    @Override
    public FileSystem getFileSystem() {
        return new LinuxFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        File[] pids;
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (File pid : pids = ProcUtil.getPidFiles()) {
            OSProcess proc = this.getProcess(ParseUtil.parseIntOrDefault(pid.getName(), 0));
            if (proc == null) continue;
            procs.add(proc);
        }
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[sorted.size()]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        String[] split = FileUtil.getSplitFromFile(String.format("/proc/%d/stat", pid));
        if (split.length < 24) {
            return null;
        }
        String path = "";
        Memory buf = new Memory(1024L);
        int size = Libc.INSTANCE.readlink(String.format("/proc/%d/exe", pid), (Pointer)buf, 1023);
        if (size > 0) {
            path = buf.getString(0L).substring(0, size);
        }
        return new LinuxProcess(split[1].replaceFirst("\\(", "").replace(")", ""), path, split[2].charAt(0), pid, ParseUtil.parseIntOrDefault(split[3], 0), ParseUtil.parseIntOrDefault(split[19], 0), ParseUtil.parseIntOrDefault(split[17], 0), ParseUtil.parseLongOrDefault(split[22], 0L), ParseUtil.parseLongOrDefault(split[23], 0L), ParseUtil.parseLongOrDefault(split[14], 0L), ParseUtil.parseLongOrDefault(split[13], 0L), ParseUtil.parseLongOrDefault(split[21], 0L), System.currentTimeMillis());
    }

    @Override
    public int getProcessId() {
        return Libc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcUtil.getPidFiles().length;
    }

    @Override
    public int getThreadCount() {
        try {
            Libc.Sysinfo info = new Libc.Sysinfo();
            if (0 != Libc.INSTANCE.sysinfo(info)) {
                LOG.error("Failed to get process thread count. Error code: " + Native.getLastError());
                return 0;
            }
            return info.procs;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            LOG.error("Failed to get procs from sysinfo. {}", (Throwable)e);
            return 0;
        }
    }

    private void setFamilyFromReleaseFiles() {
        if (this.family == null) {
            if (this.readOsRelease()) {
                return;
            }
            if (this.execLsbRelease()) {
                return;
            }
            if (this.readLsbRelease()) {
                return;
            }
            String etcDistribRelease = LinuxOperatingSystem.getReleaseFilename();
            if (this.readDistribRelease(etcDistribRelease)) {
                return;
            }
            this.family = LinuxOperatingSystem.filenameToFamily(etcDistribRelease.replace("/etc/", "").replace("release", "").replace("version", "").replace("-", "").replace("_", ""));
        }
    }

    private boolean readOsRelease() {
        if (new File("/etc/os-release").exists()) {
            List<String> osRelease = FileUtil.readFile("/etc/os-release");
            for (String line : osRelease) {
                if (line.startsWith("VERSION=")) {
                    LOG.debug("os-release: {}", (Object)line);
                    line = line.replace("VERSION=", "").replaceAll("^\"|\"$", "").trim();
                    String[] split = line.split("[()]");
                    if (split.length <= 1) {
                        split = line.split(", ");
                    }
                    if (split.length > 0) {
                        this.versionId = split[0].trim();
                    }
                    if (split.length <= 1) continue;
                    this.codeName = split[1].trim();
                    continue;
                }
                if (line.startsWith("NAME=") && this.family == null) {
                    LOG.debug("os-release: {}", (Object)line);
                    this.family = line.replace("NAME=", "").replaceAll("^\"|\"$", "").trim();
                    continue;
                }
                if (!line.startsWith("VERSION_ID=") || this.versionId != null) continue;
                LOG.debug("os-release: {}", (Object)line);
                this.versionId = line.replace("VERSION_ID=", "").replaceAll("^\"|\"$", "").trim();
            }
        }
        return this.family != null;
    }

    private boolean execLsbRelease() {
        for (String line : ExecutingCommand.runNative("lsb_release -a")) {
            if (line.startsWith("Description:")) {
                LOG.debug("lsb_release -a: {}", (Object)line);
                if (!(line = line.replace("Description:", "").trim()).contains(" release ")) continue;
                this.family = this.parseRelease(line, " release ");
                continue;
            }
            if (line.startsWith("Distributor ID:") && this.family == null) {
                LOG.debug("lsb_release -a: {}", (Object)line);
                this.family = line.replace("Distributor ID:", "").trim();
                continue;
            }
            if (line.startsWith("Release:") && this.versionId == null) {
                LOG.debug("lsb_release -a: {}", (Object)line);
                this.versionId = line.replace("Release:", "").trim();
                continue;
            }
            if (!line.startsWith("Codename:") || this.codeName != null) continue;
            LOG.debug("lsb_release -a: {}", (Object)line);
            this.codeName = line.replace("Codename:", "").trim();
        }
        return this.family != null;
    }

    private boolean readLsbRelease() {
        if (new File("/etc/lsb-release").exists()) {
            List<String> osRelease = FileUtil.readFile("/etc/lsb-release");
            for (String line : osRelease) {
                if (line.startsWith("DISTRIB_DESCRIPTION=")) {
                    LOG.debug("lsb-release: {}", (Object)line);
                    if (!(line = line.replace("DISTRIB_DESCRIPTION=", "").replaceAll("^\"|\"$", "").trim()).contains(" release ")) continue;
                    this.family = this.parseRelease(line, " release ");
                    continue;
                }
                if (line.startsWith("DISTRIB_ID=") && this.family == null) {
                    LOG.debug("lsb-release: {}", (Object)line);
                    this.family = line.replace("DISTRIB_ID=", "").replaceAll("^\"|\"$", "").trim();
                    continue;
                }
                if (line.startsWith("DISTRIB_RELEASE=") && this.versionId == null) {
                    LOG.debug("lsb-release: {}", (Object)line);
                    this.versionId = line.replace("DISTRIB_RELEASE=", "").replaceAll("^\"|\"$", "").trim();
                    continue;
                }
                if (!line.startsWith("DISTRIB_CODENAME=") || this.codeName != null) continue;
                LOG.debug("lsb-release: {}", (Object)line);
                this.codeName = line.replace("DISTRIB_CODENAME=", "").replaceAll("^\"|\"$", "").trim();
            }
        }
        return this.family != null;
    }

    private boolean readDistribRelease(String filename) {
        if (new File(filename).exists()) {
            List<String> osRelease = FileUtil.readFile(filename);
            for (String line : osRelease) {
                LOG.debug("{}: {}", (Object)filename, (Object)line);
                if (line.contains(" release ")) {
                    this.family = this.parseRelease(line, " release ");
                    break;
                }
                if (!line.contains(" VERSION ")) continue;
                this.family = this.parseRelease(line, " VERSION ");
                break;
            }
        }
        return this.family != null;
    }

    private String parseRelease(String line, String splitLine) {
        String[] split = line.split(splitLine);
        String family = split[0].trim();
        if (split.length > 1) {
            if ((split = split[1].split("[()]")).length > 0) {
                this.versionId = split[0].trim();
            }
            if (split.length > 1) {
                this.codeName = split[1].trim();
            }
        }
        return family;
    }

    protected static String getReleaseFilename() {
        File etc = new File("/etc");
        File[] matchingFiles = etc.listFiles(f -> (f.getName().endsWith("-release") || f.getName().endsWith("-version") || f.getName().endsWith("_release") || f.getName().endsWith("_version")) && !f.getName().endsWith("os-release") && !f.getName().endsWith("lsb-release"));
        if (matchingFiles != null && matchingFiles.length > 0) {
            return matchingFiles[0].getPath();
        }
        if (new File("/etc/release").exists()) {
            return "/etc/release";
        }
        return "/etc/issue";
    }

    private static String filenameToFamily(String name) {
        switch (name.toLowerCase()) {
            case "": {
                return "Solaris";
            }
            case "blackcat": {
                return "Black Cat";
            }
            case "bluewhite64": {
                return "BlueWhite64";
            }
            case "e-smith": {
                return "SME Server";
            }
            case "eos": {
                return "FreeEOS";
            }
            case "hlfs": {
                return "HLFS";
            }
            case "lfs": {
                return "Linux-From-Scratch";
            }
            case "linuxppc": {
                return "Linux-PPC";
            }
            case "meego": {
                return "MeeGo";
            }
            case "mandakelinux": {
                return "Mandrake";
            }
            case "mklinux": {
                return "MkLinux";
            }
            case "nld": {
                return "Novell Linux Desktop";
            }
            case "novell": 
            case "SuSE": {
                return "SUSE Linux";
            }
            case "pld": {
                return "PLD";
            }
            case "redhat": {
                return "Red Hat Linux";
            }
            case "sles": {
                return "SUSE Linux ES9";
            }
            case "sun": {
                return "Sun JDS";
            }
            case "synoinfo": {
                return "Synology";
            }
            case "tinysofa": {
                return "Tiny Sofa";
            }
            case "turbolinux": {
                return "TurboLinux";
            }
            case "ultrapenguin": {
                return "UltraPenguin";
            }
            case "va": {
                return "VA-Linux";
            }
            case "vmware": {
                return "VMWareESX";
            }
            case "yellowdog": {
                return "Yellow Dog";
            }
            case "issue": {
                return "Unknown";
            }
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

