/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.WinDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworks;
import oshi.jna.platform.windows.IPHlpAPI;

public class WindowsNetworks
extends AbstractNetworks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsNetworks.class);

    public static void updateNetworkStats(NetworkIF netIF) {
        IPHlpAPI.MIB_IFROW2 ifRow = new IPHlpAPI.MIB_IFROW2();
        ifRow.InterfaceIndex = new WinDef.ULONG((long)netIF.getNetworkInterface().getIndex());
        if (0 != IPHlpAPI.INSTANCE.GetIfEntry2(ifRow)) {
            LOG.error("Failed to retrieve data for interface {}, {}", (Object)netIF.getNetworkInterface().getIndex(), (Object)netIF.getName());
            return;
        }
        netIF.setTimeStamp(System.currentTimeMillis());
        netIF.setBytesSent(ifRow.OutOctets);
        netIF.setBytesRecv(ifRow.InOctets);
        netIF.setPacketsSent(ifRow.OutUcastPkts);
        netIF.setPacketsRecv(ifRow.InUcastPkts);
        netIF.setSpeed(ifRow.ReceiveLinkSpeed);
    }
}

