/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.windows.Kernel32;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsCentralProcessor.class);

    public WindowsCentralProcessor() {
        this.initVars();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        String cpuRegistryRoot = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor";
        String[] processorIds = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DESCRIPTION\\System\\CentralProcessor");
        if (processorIds.length > 0) {
            String cpuRegistryPath = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\" + processorIds[0];
            this.setVendor(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"VendorIdentifier"));
            this.setName(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"ProcessorNameString"));
            this.setIdentifier(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"Identifier"));
        }
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetNativeSystemInfo(sysinfo);
        if (sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 9 || sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 6) {
            this.setCpu64(true);
        } else if (sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue() == 0) {
            this.setCpu64(false);
        }
    }

    @Override
    protected void calculateProcessorCounts() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] processors;
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(sysinfo);
        this.logicalProcessorCount = sysinfo.dwNumberOfProcessors.intValue();
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION proc : processors = Kernel32Util.getLogicalProcessorInformation()) {
            if (proc.relationship != 0) continue;
            ++this.physicalProcessorCount;
        }
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        WinBase.FILETIME lpIdleTime = new WinBase.FILETIME();
        WinBase.FILETIME lpKernelTime = new WinBase.FILETIME();
        WinBase.FILETIME lpUserTime = new WinBase.FILETIME();
        if (!Kernel32.INSTANCE.GetSystemTimes(lpIdleTime, lpKernelTime, lpUserTime)) {
            LOG.error("Failed to update system idle/kernel/user times. Error code: " + Native.getLastError());
            return ticks;
        }
        ticks[CentralProcessor.TickType.IOWAIT.getIndex()] = FormatUtil.getUnsignedInt(WmiUtil.selectUint32From(null, "Win32_PerfRawData_PerfDisk_LogicalDisk", "AvgDisksecPerTransfer", "WHERE Name=\"_Total\"").intValue()) / 10000L;
        Map<String, List<String>> irq = WmiUtil.selectStringsFrom(null, "Win32_PerfRawData_Counters_ProcessorInformation", "PercentInterruptTime,PercentDPCTime", "WHERE Name=\"_Total\"");
        if (!irq.get("PercentInterruptTime").isEmpty()) {
            ticks[CentralProcessor.TickType.IRQ.getIndex()] = ParseUtil.parseLongOrDefault(irq.get("PercentInterruptTime").get(0), 0L) / 10000L;
            ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] = ParseUtil.parseLongOrDefault(irq.get("PercentDPCTime").get(0), 0L) / 10000L;
        }
        ticks[CentralProcessor.TickType.IDLE.getIndex()] = WinBase.FILETIME.dateToFileTime((Date)lpIdleTime.toDate()) / 10000L;
        ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = WinBase.FILETIME.dateToFileTime((Date)lpKernelTime.toDate()) / 10000L - ticks[CentralProcessor.TickType.IDLE.getIndex()];
        ticks[CentralProcessor.TickType.USER.getIndex()] = WinBase.FILETIME.dateToFileTime((Date)lpUserTime.toDate()) / 10000L;
        int n = CentralProcessor.TickType.IDLE.getIndex();
        ticks[n] = ticks[n] - ticks[CentralProcessor.TickType.IOWAIT.getIndex()];
        int n2 = CentralProcessor.TickType.SYSTEM.getIndex();
        ticks[n2] = ticks[n2] - (ticks[CentralProcessor.TickType.IRQ.getIndex()] + ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()]);
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        for (int i = 0; i < average.length; ++i) {
            average[i] = -1.0;
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        Map<String, List<String>> wmiTicks = WmiUtil.selectStringsFrom(null, "Win32_PerfRawData_Counters_ProcessorInformation", "Name,PercentIdleTime,PercentPrivilegedTime,PercentUserTime,PercentInterruptTime,PercentDPCTime", "WHERE NOT Name LIKE \"%_Total\"");
        block0: for (int index = 0; index < wmiTicks.get("Name").size(); ++index) {
            for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
                String name = "0," + cpu;
                if (!wmiTicks.get("Name").get(index).equals(name)) continue;
                ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = ParseUtil.parseLongOrDefault(wmiTicks.get("PercentUserTime").get(index), 0L) / 10000L;
                ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = ParseUtil.parseLongOrDefault(wmiTicks.get("PercentPrivilegedTime").get(index), 0L) / 10000L;
                ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = ParseUtil.parseLongOrDefault(wmiTicks.get("PercentIdleTime").get(index), 0L) / 10000L;
                ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] = ParseUtil.parseLongOrDefault(wmiTicks.get("PercentInterruptTime").get(index), 0L) / 10000L;
                ticks[cpu][CentralProcessor.TickType.SOFTIRQ.getIndex()] = ParseUtil.parseLongOrDefault(wmiTicks.get("PercentDPCTime").get(index), 0L) / 10000L;
                long[] lArray = ticks[cpu];
                int n = CentralProcessor.TickType.SYSTEM.getIndex();
                lArray[n] = lArray[n] - (ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] + ticks[cpu][CentralProcessor.TickType.SOFTIRQ.getIndex()]);
                continue block0;
            }
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        return Kernel32.INSTANCE.GetTickCount64() / 1000L;
    }

    @Override
    public String getSystemSerialNumber() {
        if (this.cpuSerialNumber == null) {
            this.cpuSerialNumber = WmiUtil.selectStringFrom(null, "Win32_BIOS", "SerialNumber", null);
            if ("".equals(this.cpuSerialNumber)) {
                this.cpuSerialNumber = WmiUtil.selectStringFrom(null, "Win32_Csproduct", "IdentifyingNumber", null);
            }
            if ("".equals(this.cpuSerialNumber)) {
                this.cpuSerialNumber = "unknown";
            }
        }
        return this.cpuSerialNumber;
    }
}

