/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import oshi.hardware.NetworkIF;
import oshi.hardware.common.AbstractNetworks;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

public class FreeBsdNetworks
extends AbstractNetworks {
    private static final long serialVersionUID = 1L;

    public static void updateNetworkStats(NetworkIF netIF) {
        String stats = ExecutingCommand.getAnswerAt("netstat -bI " + netIF.getName(), 1);
        netIF.setTimeStamp(System.currentTimeMillis());
        String[] split = stats.split("\\s+");
        if (split.length < 12) {
            return;
        }
        netIF.setBytesSent(ParseUtil.parseLongOrDefault(split[10], 0L));
        netIF.setBytesRecv(ParseUtil.parseLongOrDefault(split[7], 0L));
        netIF.setPacketsSent(ParseUtil.parseLongOrDefault(split[8], 0L));
        netIF.setPacketsRecv(ParseUtil.parseLongOrDefault(split[4], 0L));
    }
}

