/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.unix.LibC;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

public class FreeBsdCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdCentralProcessor.class);
    private static final Pattern CPUMASK = Pattern.compile(".*<cpu\\s.*mask=\"(?:0x)?(\\p{XDigit}+)\".*>.*</cpu>.*");
    private static final Pattern CPUINFO = Pattern.compile("Origin=\"([^\"]*)\".*Family=(\\S+).*Model=(\\S+).*Stepping=(\\S+).*");
    private static final long BOOTTIME;

    public FreeBsdCentralProcessor() {
        this.initVars();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        this.setName(BsdSysctlUtil.sysctl("hw.model", ""));
        List<String> cpuInfo = FileUtil.readFile("/var/run/dmesg.boot");
        for (String line : cpuInfo) {
            if ((line = line.trim()).startsWith("CPU:") && this.getName().isEmpty()) {
                this.setName(line.replace("CPU:", "").trim());
                continue;
            }
            if (!line.startsWith("Origin=")) continue;
            Matcher m = CPUINFO.matcher(line);
            if (!m.matches()) break;
            this.setVendor(m.group(1));
            this.setFamily(Integer.decode(m.group(2)).toString());
            this.setModel(Integer.decode(m.group(3)).toString());
            this.setStepping(Integer.decode(m.group(4)).toString());
            break;
        }
        this.setCpu64(ExecutingCommand.getFirstAnswer("uname -m").trim().contains("64"));
    }

    @Override
    protected void calculateProcessorCounts() {
        String[] topology = BsdSysctlUtil.sysctl("kern.sched.topology_spec", "").split("\\n|\\r");
        long physMask = 0L;
        long virtMask = 0L;
        long lastMask = 0L;
        for (String topo : topology) {
            if (topo.contains("<cpu")) {
                Matcher m = CPUMASK.matcher(topo);
                if (!m.matches()) continue;
                lastMask = Long.parseLong(m.group(1), 16);
                physMask |= lastMask;
                virtMask |= lastMask;
                continue;
            }
            if (!topo.contains("<flags>") || !topo.contains("HTT") && !topo.contains("SMT") && !topo.contains("THREAD")) continue;
            physMask &= lastMask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.logicalProcessorCount = Long.bitCount(virtMask);
        this.physicalProcessorCount = Long.bitCount(physMask);
        if (this.logicalProcessorCount < 1) {
            LOG.error("Couldn't find logical processor count. Assuming 1.");
            this.logicalProcessorCount = 1;
        }
        if (this.physicalProcessorCount < 1) {
            LOG.error("Couldn't find physical processor count. Assuming 1.");
            this.physicalProcessorCount = 1;
        }
    }

    @Override
    public synchronized long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        LibC.CpTime cpTime = new LibC.CpTime();
        BsdSysctlUtil.sysctl("kern.cp_time", cpTime);
        ticks[CentralProcessor.TickType.USER.getIndex()] = cpTime.cpu_ticks[0];
        ticks[CentralProcessor.TickType.NICE.getIndex()] = cpTime.cpu_ticks[1];
        ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = cpTime.cpu_ticks[2];
        ticks[CentralProcessor.TickType.IRQ.getIndex()] = cpTime.cpu_ticks[3];
        ticks[CentralProcessor.TickType.IDLE.getIndex()] = cpTime.cpu_ticks[4];
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = LibC.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        String name = "kern.cp_times";
        int offset = new LibC.CpTime().size();
        int size = offset * this.logicalProcessorCount;
        Memory p = new Memory((long)size);
        if (0 != LibC.INSTANCE.sysctlbyname(name, (Pointer)p, new IntByReference(size), null, 0)) {
            LOG.error("Failed syctl call: {}, Error code: {}", (Object)name, (Object)Native.getLastError());
            return ticks;
        }
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = p.getLong((long)offset * (long)cpu + (long)(0 * LibC.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] = p.getLong((long)offset * (long)cpu + (long)(1 * LibC.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = p.getLong((long)offset * (long)cpu + (long)(2 * LibC.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] = p.getLong((long)offset * (long)cpu + (long)(3 * LibC.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = p.getLong((long)offset * (long)cpu + (long)(4 * LibC.UINT64_SIZE));
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    @Override
    public String getSystemSerialNumber() {
        if (this.cpuSerialNumber == null) {
            String marker = "Serial Number:";
            for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
                if (!checkLine.contains(marker)) continue;
                this.cpuSerialNumber = checkLine.split(marker)[1].trim();
                break;
            }
            if (this.cpuSerialNumber == null) {
                marker = "system.hardware.serial =";
                for (String checkLine : ExecutingCommand.runNative("lshal")) {
                    if (!checkLine.contains(marker)) continue;
                    String[] temp = checkLine.split(marker)[1].split("'");
                    this.cpuSerialNumber = temp.length > 0 ? temp[1] : null;
                    break;
                }
            }
            if (this.cpuSerialNumber == null) {
                this.cpuSerialNumber = "unknown";
            }
        }
        return this.cpuSerialNumber;
    }

    static {
        LibC.Timeval tv = new LibC.Timeval();
        BOOTTIME = !BsdSysctlUtil.sysctl("kern.boottime", tv) || tv.tv_sec == 0L ? ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L) : tv.tv_sec;
    }
}

