/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.util.FileUtil;

public class LinuxPowerSource
extends AbstractPowerSource {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxPowerSource.class);
    private static final String PS_PATH = "/sys/class/power_supply/";

    public LinuxPowerSource(String newName, double newRemainingCapacity, double newTimeRemaining) {
        super(newName, newRemainingCapacity, newTimeRemaining);
        LOG.debug("Initialized LinuxPowerSource");
    }

    public static PowerSource[] getPowerSources() {
        File f = new File(PS_PATH);
        String[] psNames = f.list();
        if (psNames == null) {
            psNames = new String[]{};
        }
        ArrayList<LinuxPowerSource> psList = new ArrayList<LinuxPowerSource>(psNames.length);
        for (String psName : psNames) {
            List<String> psInfo;
            if (psName.startsWith("ADP") || (psInfo = FileUtil.readFile(PS_PATH + psName + "/uevent", false)).isEmpty()) continue;
            boolean isPresent = false;
            boolean isCharging = false;
            String name = "Unknown";
            int energyNow = 0;
            int energyFull = 1;
            int powerNow = 1;
            for (String checkLine : psInfo) {
                String[] psSplit;
                if (checkLine.startsWith("POWER_SUPPLY_PRESENT")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length > 1) {
                        boolean bl = isPresent = Integer.parseInt(psSplit[1]) > 0;
                    }
                    if (isPresent) continue;
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_NAME")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1) continue;
                    name = psSplit[1];
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_ENERGY_NOW") || checkLine.startsWith("POWER_SUPPLY_CHARGE_NOW")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1) continue;
                    energyNow = Integer.parseInt(psSplit[1]);
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_ENERGY_FULL") || checkLine.startsWith("POWER_SUPPLY_CHARGE_FULL")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1) continue;
                    energyFull = Integer.parseInt(psSplit[1]);
                    continue;
                }
                if (checkLine.startsWith("POWER_SUPPLY_STATUS")) {
                    psSplit = checkLine.split("=");
                    if (psSplit.length <= 1 || !"Charging".equals(psSplit[1])) continue;
                    isCharging = true;
                    continue;
                }
                if (!checkLine.startsWith("POWER_SUPPLY_POWER_NOW") && !checkLine.startsWith("POWER_SUPPLY_CURRENT_NOW")) continue;
                psSplit = checkLine.split("=");
                if (psSplit.length > 1) {
                    powerNow = Integer.parseInt(psSplit[1]);
                }
                if (powerNow > 0) continue;
                isCharging = true;
            }
            psList.add(new LinuxPowerSource(name, (double)energyNow / (double)energyFull, isCharging ? -2.0 : 3600.0 * (double)energyNow / (double)powerNow));
        }
        return psList.toArray(new LinuxPowerSource[psList.size()]);
    }
}

