/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.linux.Libc;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

public class LinuxCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxCentralProcessor.class);
    private static final String SYSFS_SERIAL_PATH = "/sys/devices/virtual/dmi/id/";

    public LinuxCentralProcessor() {
        this.initVars();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        String line;
        String[] splitLine;
        List<String> cpuInfo = FileUtil.readFile("/proc/cpuinfo");
        Iterator<String> iterator = cpuInfo.iterator();
        while (iterator.hasNext() && (splitLine = (line = iterator.next()).split("\\s+:\\s")).length >= 2) {
            switch (splitLine[0]) {
                case "vendor_id": {
                    this.setVendor(splitLine[1]);
                    break;
                }
                case "model name": {
                    this.setName(splitLine[1]);
                    break;
                }
                case "flags": {
                    String[] flags = splitLine[1].toUpperCase().split(" ");
                    boolean found = false;
                    for (String flag : flags) {
                        if (!"LM".equals(flag)) continue;
                        found = true;
                        break;
                    }
                    this.setCpu64(found);
                    break;
                }
                case "stepping": {
                    this.setStepping(splitLine[1]);
                    break;
                }
                case "model": {
                    this.setModel(splitLine[1]);
                    break;
                }
                case "cpu family": {
                    this.setFamily(splitLine[1]);
                    break;
                }
            }
        }
    }

    @Override
    protected void calculateProcessorCounts() {
        List<String> procCpu = FileUtil.readFile("/proc/cpuinfo");
        for (String cpu : procCpu) {
            if (!cpu.startsWith("processor")) continue;
            ++this.logicalProcessorCount;
        }
        int siblings = 0;
        int[] uniqueID = new int[]{-1, -1};
        HashSet<String> ids = new HashSet<String>();
        for (String cpu : procCpu) {
            if (cpu.startsWith("siblings") && (siblings = ParseUtil.parseLastInt(cpu, 1)) == 1) {
                this.physicalProcessorCount = this.logicalProcessorCount;
                break;
            }
            if (cpu.startsWith("cpu cores")) {
                int cpucores = ParseUtil.parseLastInt(cpu, 1);
                if (siblings > 1) {
                    this.physicalProcessorCount = this.logicalProcessorCount * cpucores / siblings;
                    break;
                }
            }
            if (cpu.startsWith("core id") || cpu.startsWith("cpu number")) {
                uniqueID[0] = ParseUtil.parseLastInt(cpu, 0);
            } else if (cpu.startsWith("physical id")) {
                uniqueID[1] = ParseUtil.parseLastInt(cpu, 0);
            }
            if (uniqueID[0] < 0 || uniqueID[1] < 0) continue;
            ids.add(uniqueID[0] + " " + uniqueID[1]);
            uniqueID[0] = -1;
            uniqueID[1] = -1;
        }
        if (this.physicalProcessorCount == 0) {
            this.physicalProcessorCount = ids.size();
        }
        if (this.logicalProcessorCount < 1) {
            LOG.error("Couldn't find logical processor count. Assuming 1.");
            this.logicalProcessorCount = 1;
        }
        if (this.physicalProcessorCount < 1) {
            LOG.error("Couldn't find physical processor count. Assuming 1.");
            this.physicalProcessorCount = 1;
        }
    }

    @Override
    public synchronized long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        List<String> procStat = FileUtil.readFile("/proc/stat");
        if (procStat.isEmpty()) {
            return ticks;
        }
        String tickStr = procStat.get(0);
        String[] tickArr = tickStr.split("\\s+");
        if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
            return ticks;
        }
        for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
            ticks[i] = ParseUtil.parseLongOrDefault(tickArr[i + 1], 0L);
        }
        if (tickArr.length > CentralProcessor.TickType.values().length + 1) {
            int n = CentralProcessor.TickType.SYSTEM.getIndex();
            ticks[n] = ticks[n] + ParseUtil.parseLongOrDefault(tickArr[CentralProcessor.TickType.values().length + 1], 0L);
        }
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = Libc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        int cpu = 0;
        List<String> procStat = FileUtil.readFile("/proc/stat");
        for (String stat : procStat) {
            if (!stat.startsWith("cpu") || stat.startsWith("cpu ")) continue;
            String[] tickArr = stat.split("\\s+");
            if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
                return ticks;
            }
            for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
                ticks[cpu][i] = ParseUtil.parseLongOrDefault(tickArr[i + 1], 0L);
            }
            if (tickArr.length > CentralProcessor.TickType.values().length + 1) {
                long[] lArray = ticks[cpu];
                int n = CentralProcessor.TickType.SYSTEM.getIndex();
                lArray[n] = lArray[n] + ParseUtil.parseLongOrDefault(tickArr[CentralProcessor.TickType.values().length + 1], 0L);
            }
            if (++cpu < this.logicalProcessorCount) continue;
            break;
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        return (long)ProcUtil.getSystemUptimeFromProc();
    }

    @Override
    public String getSystemSerialNumber() {
        if (this.cpuSerialNumber == null) {
            String marker = "Serial Number:";
            for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
                if (!checkLine.contains(marker)) continue;
                this.cpuSerialNumber = checkLine.split(marker)[1].trim();
                break;
            }
            if (this.cpuSerialNumber == null) {
                marker = "system.hardware.serial =";
                for (String checkLine : ExecutingCommand.runNative("lshal")) {
                    if (!checkLine.contains(marker)) continue;
                    String[] temp = checkLine.split(marker)[1].split("'");
                    this.cpuSerialNumber = temp.length > 0 ? temp[1] : null;
                    break;
                }
            }
            if (this.cpuSerialNumber == null) {
                this.cpuSerialNumber = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_serial");
                if (this.cpuSerialNumber.isEmpty() || "None".equals(this.cpuSerialNumber)) {
                    this.cpuSerialNumber = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial");
                    if (this.cpuSerialNumber.isEmpty() || "None".equals(this.cpuSerialNumber)) {
                        this.cpuSerialNumber = "unknown";
                    }
                }
            }
        }
        return this.cpuSerialNumber;
    }
}

