/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.Serializable;
import oshi.jna.platform.linux.Udev;
import oshi.util.ParseUtil;

public class LinuxBlockDevStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String device;
    public final long read_ops;
    public final long read_merged;
    public final long read_512bytes;
    public final long read_waits_ms;
    public final long write_ops;
    public final long write_merged;
    public final long write_512bytes;
    public final long write_waits_ms;
    public final long in_flight;
    public final long active_ms;
    public final long waits_ms;

    public LinuxBlockDevStats(String device, Udev.UdevDevice disk) {
        String devstat = Udev.INSTANCE.udev_device_get_sysattr_value(disk, "stat");
        String[] splitstats = devstat.split("\\s+");
        this.device = device;
        this.read_ops = ParseUtil.parseLongOrDefault(splitstats[1], 0L);
        this.read_merged = ParseUtil.parseLongOrDefault(splitstats[2], 0L);
        this.read_512bytes = ParseUtil.parseLongOrDefault(splitstats[3], 0L);
        this.read_waits_ms = ParseUtil.parseLongOrDefault(splitstats[4], 0L);
        this.write_ops = ParseUtil.parseLongOrDefault(splitstats[5], 0L);
        this.write_merged = ParseUtil.parseLongOrDefault(splitstats[6], 0L);
        this.write_512bytes = ParseUtil.parseLongOrDefault(splitstats[7], 0L);
        this.write_waits_ms = ParseUtil.parseLongOrDefault(splitstats[8], 0L);
        this.in_flight = ParseUtil.parseLongOrDefault(splitstats[9], 0L);
        this.active_ms = ParseUtil.parseLongOrDefault(splitstats[10], 0L);
        this.waits_ms = ParseUtil.parseLongOrDefault(splitstats[11], 0L);
    }
}

