/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.util.ParseUtil;

public abstract class AbstractCentralProcessor
implements CentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCentralProcessor.class);
    private static final java.lang.management.OperatingSystemMXBean OS_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    private double lastCpuLoad = 0.0;
    private long lastCpuLoadTime = 0L;
    private boolean sunMXBean = false;
    protected int logicalProcessorCount = 0;
    protected int physicalProcessorCount = 0;
    private long tickTime;
    private long[] prevTicks;
    private long[] curTicks;
    private long procTickTime;
    private long[][] prevProcTicks;
    private long[][] curProcTicks;
    private String cpuVendor;
    private String cpuName;
    protected String cpuSerialNumber = null;
    private String cpuIdentifier;
    private String cpuStepping;
    private String cpuModel;
    private String cpuFamily;
    private Long cpuVendorFreq;
    private Boolean cpu64;

    public AbstractCentralProcessor() {
        this.initMXBean();
        this.calculateProcessorCounts();
    }

    private void initMXBean() {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            this.lastCpuLoad = ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
            this.lastCpuLoadTime = System.currentTimeMillis();
            this.sunMXBean = true;
            LOG.debug("Oracle MXBean detected.");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Oracle MXBean not detected.");
            LOG.trace("", (Throwable)e);
        }
    }

    protected synchronized void initTicks() {
        this.prevProcTicks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        this.curProcTicks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        this.updateProcessorTicks();
        this.prevTicks = new long[CentralProcessor.TickType.values().length];
        this.curTicks = new long[CentralProcessor.TickType.values().length];
        this.updateSystemTicks();
    }

    protected abstract void calculateProcessorCounts();

    @Override
    public String getVendor() {
        if (this.cpuVendor == null) {
            this.setVendor("");
        }
        return this.cpuVendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.cpuVendor = vendor;
    }

    @Override
    public String getName() {
        if (this.cpuName == null) {
            this.setName("");
        }
        return this.cpuName;
    }

    @Override
    public void setName(String name) {
        this.cpuName = name;
    }

    @Override
    public long getVendorFreq() {
        if (this.cpuVendorFreq == null) {
            Pattern pattern = Pattern.compile("@ (.*)$");
            Matcher matcher = pattern.matcher(this.getName());
            if (matcher.find()) {
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz(unit);
            } else {
                this.cpuVendorFreq = -1L;
            }
        }
        return this.cpuVendorFreq;
    }

    @Override
    public void setVendorFreq(long freq) {
        this.cpuVendorFreq = freq;
    }

    @Override
    public String getIdentifier() {
        if (this.cpuIdentifier == null) {
            StringBuilder sb = new StringBuilder();
            if (this.getVendor().contentEquals("GenuineIntel")) {
                sb.append(this.isCpu64bit() ? "Intel64" : "x86");
            } else {
                sb.append(this.getVendor());
            }
            sb.append(" Family ").append(this.getFamily());
            sb.append(" Model ").append(this.getModel());
            sb.append(" Stepping ").append(this.getStepping());
            this.setIdentifier(sb.toString());
        }
        return this.cpuIdentifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.cpuIdentifier = identifier;
    }

    @Override
    public boolean isCpu64bit() {
        if (this.cpu64 == null) {
            this.setCpu64(false);
        }
        return this.cpu64;
    }

    @Override
    public void setCpu64(boolean value) {
        this.cpu64 = value;
    }

    @Override
    public String getStepping() {
        if (this.cpuStepping == null) {
            if (this.cpuIdentifier == null) {
                return "?";
            }
            this.setStepping(this.parseIdentifier("Stepping"));
        }
        return this.cpuStepping;
    }

    @Override
    public void setStepping(String stepping) {
        this.cpuStepping = stepping;
    }

    @Override
    public String getModel() {
        if (this.cpuModel == null) {
            if (this.cpuIdentifier == null) {
                return "?";
            }
            this.setModel(this.parseIdentifier("Model"));
        }
        return this.cpuModel;
    }

    @Override
    public void setModel(String model) {
        this.cpuModel = model;
    }

    @Override
    public String getFamily() {
        if (this.cpuFamily == null) {
            if (this.cpuIdentifier == null) {
                return "?";
            }
            this.setFamily(this.parseIdentifier("Family"));
        }
        return this.cpuFamily;
    }

    @Override
    public void setFamily(String family) {
        this.cpuFamily = family;
    }

    private String parseIdentifier(String id) {
        String[] idSplit = this.getIdentifier().split("\\s+");
        boolean found = false;
        for (String s : idSplit) {
            if (found) {
                return s;
            }
            found = s.equals(id);
        }
        return "";
    }

    @Override
    public synchronized double getSystemCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last tick time: {}", (Object)now, (Object)this.tickTime);
        if (now - this.tickTime > 950L) {
            this.updateSystemTicks();
        }
        long total = 0L;
        for (int i = 0; i < this.curTicks.length; ++i) {
            total += this.curTicks[i] - this.prevTicks[i];
        }
        long idle = this.curTicks[CentralProcessor.TickType.IDLE.getIndex()] + this.curTicks[CentralProcessor.TickType.IOWAIT.getIndex()] - this.prevTicks[CentralProcessor.TickType.IDLE.getIndex()] - this.prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)total, (Object)idle);
        return total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
    }

    protected void updateSystemTicks() {
        long[] ticks;
        LOG.trace("Updating System Ticks");
        for (long tick : ticks = this.getSystemCpuLoadTicks()) {
            if (tick == 0L) continue;
            this.tickTime = System.currentTimeMillis();
            System.arraycopy(this.curTicks, 0, this.prevTicks, 0, this.curTicks.length);
            System.arraycopy(ticks, 0, this.curTicks, 0, ticks.length);
            return;
        }
    }

    @Override
    public double getSystemCpuLoad() {
        if (this.sunMXBean) {
            long now = System.currentTimeMillis();
            if (now - this.lastCpuLoadTime < 200L) {
                return this.lastCpuLoad;
            }
            this.lastCpuLoad = ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
            this.lastCpuLoadTime = now;
            return this.lastCpuLoad;
        }
        return this.getSystemCpuLoadBetweenTicks();
    }

    @Override
    public double getSystemLoadAverage() {
        return this.getSystemLoadAverage(1)[0];
    }

    @Override
    public double[] getProcessorCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        LOG.trace("Current time: {}  Last tick time: {}", (Object)now, (Object)this.procTickTime);
        if (now - this.procTickTime > 950L) {
            this.updateProcessorTicks();
        }
        double[] load = new double[this.logicalProcessorCount];
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            long total = 0L;
            for (int i = 0; i < this.curProcTicks[cpu].length; ++i) {
                total += this.curProcTicks[cpu][i] - this.prevProcTicks[cpu][i];
            }
            long idle = this.curProcTicks[cpu][CentralProcessor.TickType.IDLE.getIndex()] + this.curProcTicks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()] - this.prevProcTicks[cpu][CentralProcessor.TickType.IDLE.getIndex()] - this.prevProcTicks[cpu][CentralProcessor.TickType.IOWAIT.getIndex()];
            LOG.trace("CPU: {}  Total ticks: {}  Idle ticks: {}", new Object[]{cpu, total, idle});
            load[cpu] = total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
        }
        return load;
    }

    protected void updateProcessorTicks() {
        long[][] ticks;
        LOG.trace("Updating Processor Ticks");
        long[][] lArray = ticks = this.getProcessorCpuLoadTicks();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] tick;
            for (long element : tick = lArray[i]) {
                int cpu;
                if (element == 0L) continue;
                this.procTickTime = System.currentTimeMillis();
                for (cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
                    System.arraycopy(this.curProcTicks[cpu], 0, this.prevProcTicks[cpu], 0, this.curProcTicks[cpu].length);
                }
                for (cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
                    System.arraycopy(ticks[cpu], 0, this.curProcTicks[cpu], 0, ticks[cpu].length);
                }
                return;
            }
        }
    }

    @Override
    public int getLogicalProcessorCount() {
        return this.logicalProcessorCount;
    }

    @Override
    public int getPhysicalProcessorCount() {
        return this.physicalProcessorCount;
    }

    public String toString() {
        return this.getName();
    }
}

