/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ParseUtil {
    private static final String Hertz = "Hz";
    private static final String kiloHertz = "kHz";
    private static final String megaHertz = "MHz";
    private static final String gigaHertz = "GHz";
    private static final String teraHertz = "THz";
    private static final String petaHertz = "PHz";
    private static final Map<String, Long> multipliers = new HashMap<String, Long>();

    public static long parseHertz(String hertz) {
        Pattern pattern = Pattern.compile("(\\d+(.\\d+)?) ?([kMGT]?Hz)");
        Matcher matcher = pattern.matcher(hertz.trim());
        if (matcher.find() && matcher.groupCount() == 3) {
            try {
                Double value = Double.valueOf(matcher.group(1));
                String unit = matcher.group(3);
                if (multipliers.containsKey(unit)) {
                    value = value * (double)multipliers.get(unit).longValue();
                    return value.longValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    static {
        multipliers.put(Hertz, 1L);
        multipliers.put(kiloHertz, 1000L);
        multipliers.put(megaHertz, 1000000L);
        multipliers.put(gigaHertz, 1000000000L);
        multipliers.put(teraHertz, 1000000000000L);
        multipliers.put(petaHertz, 1000000000000000L);
    }
}

