/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;

public abstract class FormatUtil {
    private static final long kibiByte = 1024L;
    private static final long mebiByte = 0x100000L;
    private static final long gibiByte = 0x40000000L;
    private static final long tebiByte = 0x10000000000L;
    private static final long pebiByte = 0x4000000000000L;
    private static final long exbiByte = 0x1000000000000000L;
    private static final long kiloHertz = 1000L;
    private static final long megaHertz = 1000000L;
    private static final long gigaHertz = 1000000000L;
    private static final long teraHertz = 1000000000000L;
    private static final long petaHertz = 1000000000000000L;
    private static final long exaHertz = 1000000000000000000L;

    public static String formatBytes(long bytes) {
        if (bytes == 1L) {
            return String.format("%d byte", bytes);
        }
        if (bytes < 1024L) {
            return String.format("%d bytes", bytes);
        }
        if (bytes < 0x100000L && bytes % 1024L == 0L) {
            return String.format("%.0f KiB", (double)bytes / 1024.0);
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KiB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L && bytes % 0x100000L == 0L) {
            return String.format("%.0f MiB", (double)bytes / 1048576.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%.1f MiB", (double)bytes / 1048576.0);
        }
        if (bytes % 0x40000000L == 0L && bytes < 0x10000000000L) {
            return String.format("%.0f GiB", (double)bytes / 1.073741824E9);
        }
        if (bytes < 0x10000000000L) {
            return String.format("%.1f GiB", (double)bytes / 1.073741824E9);
        }
        if (bytes % 0x10000000000L == 0L && bytes < 0x4000000000000L) {
            return String.format("%.0f TiB", (double)bytes / 1.099511627776E12);
        }
        if (bytes < 0x4000000000000L) {
            return String.format("%.1f TiB", (double)bytes / 1.099511627776E12);
        }
        if (bytes % 0x4000000000000L == 0L && bytes < 0x1000000000000000L) {
            return String.format("%.0f PiB", (double)bytes / 1.125899906842624E15);
        }
        if (bytes < 0x1000000000000000L) {
            return String.format("%.1f PiB", (double)bytes / 1.125899906842624E15);
        }
        return String.format("%d bytes", bytes);
    }

    public static String formatHertz(long hertz) {
        if (hertz < 1000L) {
            return String.format("%d Hz", hertz);
        }
        if (hertz < 1000000L && hertz % 1000L == 0L) {
            return String.format("%.0f kHz", (double)hertz / 1000.0);
        }
        if (hertz < 1000000L) {
            return String.format("%.1f kHz", (double)hertz / 1000.0);
        }
        if (hertz < 1000000000L && hertz % 1000000L == 0L) {
            return String.format("%.0f MHz", (double)hertz / 1000000.0);
        }
        if (hertz < 1000000000L) {
            return String.format("%.1f MHz", (double)hertz / 1000000.0);
        }
        if (hertz < 1000000000000L && hertz % 1000000000L == 0L) {
            return String.format("%.0f GHz", (double)hertz / 1.0E9);
        }
        if (hertz < 1000000000000L) {
            return String.format("%.1f GHz", (double)hertz / 1.0E9);
        }
        if (hertz < 1000000000000000L && hertz % 1000000000000L == 0L) {
            return String.format("%.0f THz", (double)hertz / 1.0E12);
        }
        if (hertz < 1000000000000000L) {
            return String.format("%.1f THz", (double)hertz / 1.0E12);
        }
        if (hertz < 1000000000000000000L && hertz % 1000000000000000L == 0L) {
            return String.format("%.0f EHz", (double)hertz / 1.0E15);
        }
        if (hertz < 1000000000000000000L) {
            return String.format("%.1f EHz", (double)hertz / 1.0E15);
        }
        return String.format("%d Hz", hertz);
    }

    public static String formatElapsedSecs(long secs) {
        long eTime = secs;
        long days = TimeUnit.SECONDS.toDays(eTime);
        long hr = TimeUnit.SECONDS.toHours(eTime -= TimeUnit.DAYS.toSeconds(days));
        long min = TimeUnit.SECONDS.toMinutes(eTime -= TimeUnit.HOURS.toSeconds(hr));
        long sec = eTime -= TimeUnit.MINUTES.toSeconds(min);
        return String.format("%d days, %02d:%02d:%02d", days, hr, min, sec);
    }

    public static float round(float d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Float.toString(d));
        bd = bd.setScale(decimalPlace, 4);
        return bd.floatValue();
    }

    public static long getUnsignedInt(int x) {
        return (long)x & 0xFFFFFFFFL;
    }
}

