/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows.nt;

import com.sun.jna.NativeLong;
import oshi.hardware.PowerSource;
import oshi.software.os.windows.nt.PowrProf;
import oshi.util.FormatUtil;

public class WindowsPowerSource
implements PowerSource {
    private String name;
    private double remainingCapacity;
    private double timeRemaining;

    public WindowsPowerSource(String name, double remainingCapacity, double timeRemaining) {
        this.name = name;
        this.remainingCapacity = remainingCapacity;
        this.timeRemaining = timeRemaining;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getRemainingCapacity() {
        return this.remainingCapacity;
    }

    @Override
    public double getTimeRemaining() {
        return this.timeRemaining;
    }

    public static PowerSource[] getPowerSources() {
        String name = "System Battery";
        PowerSource[] psArray = new WindowsPowerSource[1];
        PowrProf.SystemBatteryState batteryState = new PowrProf.SystemBatteryState();
        if (0 != PowrProf.INSTANCE.CallNtPowerInformation(5, null, new NativeLong(0L), batteryState, new NativeLong((long)batteryState.size())) || batteryState.batteryPresent == 0) {
            psArray[0] = new WindowsPowerSource("Unknown", 0.0, -1.0);
        } else {
            int estimatedTime = -2;
            if (batteryState.acOnLine == 0 && batteryState.charging == 0 && batteryState.discharging > 0) {
                estimatedTime = batteryState.estimatedTime;
            }
            long maxCapacity = FormatUtil.getUnsignedInt(batteryState.maxCapacity);
            long remainingCapacity = FormatUtil.getUnsignedInt(batteryState.remainingCapacity);
            psArray[0] = new WindowsPowerSource(name, (double)remainingCapacity / (double)maxCapacity, estimatedTime);
        }
        return psArray;
    }
}

