/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows.nt;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oshi.hardware.Processor;
import oshi.software.os.windows.nt.Kernel32;
import oshi.software.os.windows.nt.Pdh;
import oshi.util.ParseUtil;

public class CentralProcessor
implements Processor {
    private static final java.lang.management.OperatingSystemMXBean OS_MXBEAN = ManagementFactory.getOperatingSystemMXBean();
    private static boolean sunMXBean;
    private static long tickTime;
    private static long[] prevTicks;
    private static long[] curTicks;
    private long procTickTime = System.currentTimeMillis();
    private long[] prevProcTicks = new long[4];
    private long[] curProcTicks = new long[4];
    private static PointerByReference phQuery;
    private static final IntByReference zero;
    private static final int numCPU;
    private static PointerByReference uptimeQuery;
    private static final IntByReference one;
    private static PointerByReference[] phUserCounters;
    private static PointerByReference[] phIdleCounters;
    private static PointerByReference pUptime;
    private static long[][] allProcessorTicks;
    private static long allProcTickTime;
    private int processorNumber;
    private String cpuVendor;
    private String cpuName;
    private String cpuIdentifier;
    private Long cpuVendorFreq;

    public CentralProcessor(int procNo) {
        if (procNo >= numCPU) {
            throw new IllegalArgumentException("Processor number (" + procNo + ") must be less than the number of CPUs: " + numCPU);
        }
        this.processorNumber = procNo;
        this.updateProcessorTicks();
        System.arraycopy(allProcessorTicks[this.processorNumber], 0, this.curProcTicks, 0, this.curProcTicks.length);
    }

    @Override
    public int getProcessorNumber() {
        return this.processorNumber;
    }

    @Override
    public String getVendor() {
        return this.cpuVendor;
    }

    @Override
    public void setVendor(String vendor) {
        this.cpuVendor = vendor;
    }

    @Override
    public String getName() {
        return this.cpuName;
    }

    @Override
    public void setName(String name) {
        this.cpuName = name;
    }

    @Override
    public long getVendorFreq() {
        if (this.cpuVendorFreq == null) {
            Pattern pattern = Pattern.compile("@ (.*)$");
            Matcher matcher = pattern.matcher(this.getName());
            if (matcher.find()) {
                String unit = matcher.group(1);
                this.cpuVendorFreq = ParseUtil.parseHertz(unit);
            } else {
                this.cpuVendorFreq = -1L;
            }
        }
        return this.cpuVendorFreq;
    }

    @Override
    public void setVendorFreq(long freq) {
        this.cpuVendorFreq = freq;
    }

    @Override
    public String getIdentifier() {
        return this.cpuIdentifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.cpuIdentifier = identifier;
    }

    @Override
    public boolean isCpu64bit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCpu64(boolean cpu64) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStepping() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStepping(String stepping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setModel(String model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFamily() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFamily(String family) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public float getLoad() {
        return (float)this.getSystemCpuLoadBetweenTicks() * 100.0f;
    }

    @Override
    public double getSystemCpuLoadBetweenTicks() {
        boolean update;
        long now = System.currentTimeMillis();
        boolean bl = update = now - tickTime > 950L;
        if (update) {
            CentralProcessor.updateSystemTicks();
            tickTime = now;
        }
        long total = 0L;
        for (int i = 0; i < curTicks.length; ++i) {
            total += curTicks[i] - prevTicks[i];
        }
        long idle = curTicks[3] - prevTicks[3];
        if (update) {
            System.arraycopy(curTicks, 0, prevTicks, 0, curTicks.length);
        }
        if (total > 0L && idle >= 0L) {
            return (double)(total - idle) / (double)total;
        }
        return 0.0;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        CentralProcessor.updateSystemTicks();
        long[] ticks = new long[curTicks.length];
        System.arraycopy(curTicks, 0, ticks, 0, curTicks.length);
        return ticks;
    }

    private static void updateSystemTicks() {
        WinBase.FILETIME lpIdleTime = new WinBase.FILETIME();
        WinBase.FILETIME lpKernelTime = new WinBase.FILETIME();
        WinBase.FILETIME lpUserTime = new WinBase.FILETIME();
        if (0 == Kernel32.INSTANCE.GetSystemTimes(lpIdleTime, lpKernelTime, lpUserTime)) {
            throw new LastErrorException("Error code: " + Native.getLastError());
        }
        CentralProcessor.curTicks[0] = lpUserTime.toLong() + 11644473600000L;
        CentralProcessor.curTicks[1] = 0L;
        CentralProcessor.curTicks[2] = lpKernelTime.toLong() - lpIdleTime.toLong();
        CentralProcessor.curTicks[3] = lpIdleTime.toLong() + 11644473600000L;
    }

    @Override
    public double getSystemCpuLoad() {
        if (sunMXBean) {
            return ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
        }
        return this.getSystemCpuLoadBetweenTicks();
    }

    @Override
    public double getSystemLoadAverage() {
        return OS_MXBEAN.getSystemLoadAverage();
    }

    @Override
    public double getProcessorCpuLoadBetweenTicks() {
        long now = System.currentTimeMillis();
        if (now - this.procTickTime > 950L) {
            this.updateProcessorTicks();
            System.arraycopy(this.curProcTicks, 0, this.prevProcTicks, 0, this.curProcTicks.length);
            System.arraycopy(allProcessorTicks[this.processorNumber], 0, this.curProcTicks, 0, this.curProcTicks.length);
            this.procTickTime = now;
        }
        long total = 0L;
        for (int i = 0; i < this.curProcTicks.length; ++i) {
            total += this.curProcTicks[i] - this.prevProcTicks[i];
        }
        long idle = this.curProcTicks[3] - this.prevProcTicks[3];
        return total > 0L && idle >= 0L ? (double)(total - idle) / (double)total : 0.0;
    }

    @Override
    public long[] getProcessorCpuLoadTicks() {
        this.updateProcessorTicks();
        return allProcessorTicks[this.processorNumber];
    }

    private void updateProcessorTicks() {
        long now = System.currentTimeMillis();
        if (now - allProcTickTime < 100L) {
            return;
        }
        int ret = Pdh.INSTANCE.PdhCollectQueryData(phQuery.getValue());
        if (ret != 0) {
            throw new LastErrorException("Cannot collect PDH query data. Error code: " + String.format("0x%08X", ret));
        }
        long elapsed = now - allProcTickTime;
        for (int cpu = 0; cpu < numCPU; ++cpu) {
            Pdh.PdhFmtCounterValue phUserCounterValue = new Pdh.PdhFmtCounterValue();
            ret = Pdh.INSTANCE.PdhGetFormattedCounterValue(phUserCounters[cpu].getValue(), 9216, null, phUserCounterValue);
            if (ret != 0) {
                throw new LastErrorException("Cannot get PDH User % counter value. Error code: " + String.format("0x%08X", ret));
            }
            Pdh.PdhFmtCounterValue phIdleCounterValue = new Pdh.PdhFmtCounterValue();
            ret = Pdh.INSTANCE.PdhGetFormattedCounterValue(phIdleCounters[cpu].getValue(), 9216, null, phIdleCounterValue);
            if (ret != 0) {
                throw new LastErrorException("Cannot get PDH Idle % counter value. Error code: " + String.format("0x%08X", ret));
            }
            long user = elapsed * phUserCounterValue.value.largeValue / 100000L;
            long idle = elapsed * phIdleCounterValue.value.largeValue / 100000L;
            long[] lArray = allProcessorTicks[cpu];
            lArray[0] = lArray[0] + user;
            long[] lArray2 = allProcessorTicks[cpu];
            lArray2[2] = lArray2[2] + (elapsed - user - idle);
            long[] lArray3 = allProcessorTicks[cpu];
            lArray3[3] = lArray3[3] + idle;
        }
        allProcTickTime = now;
    }

    @Override
    public long getSystemUptime() {
        int ret = Pdh.INSTANCE.PdhCollectQueryData(uptimeQuery.getValue());
        if (ret != 0) {
            throw new LastErrorException("Cannot collect uptime query data. Error code: " + String.format("0x%08X", ret));
        }
        Pdh.PdhFmtCounterValue uptimeCounterValue = new Pdh.PdhFmtCounterValue();
        ret = Pdh.INSTANCE.PdhGetFormattedCounterValue(pUptime.getValue(), 1024, null, uptimeCounterValue);
        if (ret != 0) {
            throw new LastErrorException("Cannot get PDH User % counter value. Error code: " + String.format("0x%08X", ret));
        }
        return uptimeCounterValue.value.largeValue;
    }

    public String toString() {
        return this.getName();
    }

    static {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            ((OperatingSystemMXBean)OS_MXBEAN).getSystemCpuLoad();
            sunMXBean = true;
        }
        catch (ClassNotFoundException e) {
            sunMXBean = false;
        }
        tickTime = System.currentTimeMillis();
        prevTicks = new long[4];
        curTicks = new long[4];
        CentralProcessor.updateSystemTicks();
        System.arraycopy(curTicks, 0, prevTicks, 0, curTicks.length);
        phQuery = new PointerByReference();
        zero = new IntByReference(0);
        uptimeQuery = new PointerByReference();
        one = new IntByReference(1);
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetSystemInfo(sysinfo);
        numCPU = sysinfo.dwNumberOfProcessors.intValue();
        int ret = Pdh.INSTANCE.PdhOpenQuery(null, zero, phQuery);
        if (ret != 0) {
            throw new LastErrorException("Cannot open PDH query. Error code: " + String.format("0x%08X", ret));
        }
        ret = Pdh.INSTANCE.PdhOpenQuery(null, one, uptimeQuery);
        if (ret != 0) {
            throw new LastErrorException("Cannot open PDH query. Error code: " + String.format("0x%08X", ret));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Pdh.INSTANCE.PdhCloseQuery(phQuery.getValue());
                Pdh.INSTANCE.PdhCloseQuery(uptimeQuery.getValue());
            }
        });
        phUserCounters = new PointerByReference[numCPU];
        phIdleCounters = new PointerByReference[numCPU];
        for (int p = 0; p < numCPU; ++p) {
            String counterPath = String.format("\\Processor(%d)\\%% user time", p);
            CentralProcessor.phUserCounters[p] = new PointerByReference();
            int ret2 = Pdh.INSTANCE.PdhAddEnglishCounterA(phQuery.getValue(), counterPath, zero, phUserCounters[p]);
            if (ret2 != 0) {
                throw new LastErrorException("Cannot add PDH Counter for % user time for processor " + p + ". Error code: " + String.format("0x%08X", ret2));
            }
            counterPath = String.format("\\Processor(%d)\\%% idle time", p);
            CentralProcessor.phIdleCounters[p] = new PointerByReference();
            ret2 = Pdh.INSTANCE.PdhAddEnglishCounterA(phQuery.getValue(), counterPath, zero, phIdleCounters[p]);
            if (ret2 == 0) continue;
            throw new LastErrorException("Cannot add PDH Counter for % idle time for processor " + p + ". Error code: " + String.format("0x%08X", ret2));
        }
        int ret3 = Pdh.INSTANCE.PdhCollectQueryData(phQuery.getValue());
        if (ret3 != 0) {
            throw new LastErrorException("Cannot collect PDH query data. Error code: " + String.format("0x%08X", ret3));
        }
        String uptimePath = "\\System\\System Up Time";
        pUptime = new PointerByReference();
        ret = Pdh.INSTANCE.PdhAddEnglishCounterA(uptimeQuery.getValue(), uptimePath, one, pUptime);
        if (ret != 0) {
            throw new LastErrorException("Cannot add PDH Counter for uptime. Error code: " + String.format("0x%08X", ret));
        }
        allProcessorTicks = new long[numCPU][4];
        allProcTickTime = System.currentTimeMillis() - 100L;
    }
}

