/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac.local;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import oshi.software.os.OSFileStore;

public class MacFileSystem {
    private static final Pattern localDisk = Pattern.compile("/dev/disk\\d");

    public static OSFileStore[] getFileStores() {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        FileSystemView fsv = FileSystemView.getFileSystemView();
        File volumes = new File("/Volumes");
        if (volumes != null && volumes.listFiles() != null) {
            for (File f : volumes.listFiles()) {
                String description;
                String name;
                block6: {
                    if (f.getName().endsWith(".DS_Store")) continue;
                    name = fsv.getSystemDisplayName(f);
                    description = "Volume";
                    try {
                        FileStore fs;
                        if (f.getCanonicalPath().equals("/")) {
                            name = name + " (/)";
                        }
                        if (localDisk.matcher((fs = Files.getFileStore(f.toPath())).name()).matches()) {
                            description = "Local Disk";
                        }
                        if (!fs.name().startsWith("localhost:") && !fs.name().startsWith("//")) break block6;
                        description = "Network Drive";
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                fsList.add(new OSFileStore(name, description, f.getUsableSpace(), f.getTotalSpace()));
            }
        }
        return fsList.toArray(new OSFileStore[fsList.size()]);
    }
}

