/*
 * Decompiled with CFR 0.152.
 */
package com.dpizarro.uipicker.library.picker;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.dpizarro.uipicker.library.R;
import com.dpizarro.uipicker.library.picker.PickerUIAdapter;
import java.util.Arrays;
import java.util.List;

class PickerUIListView
extends ListView {
    private static final int ROW_HEIGHT = 40;
    private PickerUIItemClickListener mItemClickListenerPickerUI;
    private PickerUIAdapter mPickerUIAdapter;
    private boolean scrollEnabled = false;
    private int lastPositionNotified;
    private int firstItem;
    private int scrollTop;
    private List<String> items;
    private int which;

    public PickerUIListView(Context context) {
        super(context);
        if (this.isInEditMode()) {
            this.createEditModeView(context);
        } else {
            this.init(this.items);
        }
    }

    public PickerUIListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            this.createEditModeView(context);
        } else {
            this.init(this.items);
        }
    }

    public PickerUIListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.isInEditMode()) {
            this.createEditModeView(context);
        } else {
            this.init(this.items);
        }
    }

    public PickerUIListView(Activity context, List<String> items) {
        super((Context)context);
        if (this.isInEditMode()) {
            this.createEditModeView((Context)context);
        } else {
            this.init(items);
        }
    }

    private void createEditModeView(Context context) {
        String[] entries = new String[10];
        for (int i = 0; i < 10; ++i) {
            entries[i] = "item " + i;
        }
        List<String> entriesList = Arrays.asList(entries);
        this.mPickerUIAdapter = new PickerUIAdapter(context, R.layout.pickerui_item, entriesList, entriesList.size() / 2, true, true);
        this.setAdapter((ListAdapter)this.mPickerUIAdapter);
        this.setSelection(entriesList.size() / 2);
    }

    private void init(List<String> items) {
        this.items = items;
        ViewTreeObserver observer = this.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                PickerUIListView.this.scrollEnabled = true;
                if (PickerUIListView.this.items != null) {
                    PickerUIListView.this.selectListItem(PickerUIListView.this.items.size() / 2, false);
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    PickerUIListView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    PickerUIListView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0) {
                    PickerUIListView.this.getItemInListCenter();
                    if (PickerUIListView.this.scrollTop < -40) {
                        PickerUIListView.this.mPickerUIAdapter.handleSelectEvent(PickerUIListView.this.firstItem + 1 + 2);
                        PickerUIListView.this.selectListItem(PickerUIListView.this.firstItem + 1);
                    } else {
                        PickerUIListView.this.selectListItem(PickerUIListView.this.firstItem);
                    }
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                View v = PickerUIListView.this.getChildAt(0);
                PickerUIListView.this.scrollTop = v == null ? 0 : v.getTop();
                PickerUIListView.this.firstItem = firstVisibleItem;
                if (PickerUIListView.this.scrollEnabled) {
                    PickerUIListView.this.getItemInListCenter();
                }
            }
        });
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                PickerUIListView.this.setNewPositionCenter(position);
            }
        });
    }

    public void setItems(Context context, List<String> items, int idRequestPickerUI, int position, boolean itemsClickables) {
        this.items = items;
        this.which = idRequestPickerUI;
        this.mPickerUIAdapter = new PickerUIAdapter(context, R.layout.pickerui_item, items, position, itemsClickables, false);
        this.setAdapter((ListAdapter)this.mPickerUIAdapter);
    }

    private void selectListItem(final int position, boolean notify) {
        this.setSelection(position);
        if (notify) {
            Handler handler = new Handler();
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PickerUIListView.this.mItemClickListenerPickerUI == null) {
                        throw new IllegalStateException("You must assign a valid PickerUIListView.PickerUIItemClickListener first!");
                    }
                    PickerUIListView.this.mItemClickListenerPickerUI.onItemClickItemPickerUI(PickerUIListView.this.which, position, (String)PickerUIListView.this.items.get(position));
                }
            }, 200L);
        }
    }

    private void selectListItem(int position) {
        this.selectListItem(position, true);
    }

    private void setNewPositionCenter(int position) {
        this.mPickerUIAdapter.handleSelectEvent(position);
        this.selectListItem(position - 2);
    }

    public int getItemInListCenter() {
        int position = this.pointToPosition(this.getWidth() / 2, this.getHeight() / 2);
        if (position != -1 && position != this.lastPositionNotified) {
            this.lastPositionNotified = position;
            this.mPickerUIAdapter.handleSelectEvent(position);
        }
        return position - 2;
    }

    PickerUIAdapter getPickerUIAdapter() {
        return this.mPickerUIAdapter;
    }

    void setOnClickItemPickerUIListener(PickerUIItemClickListener listener) {
        this.mItemClickListenerPickerUI = listener;
    }

    static interface PickerUIItemClickListener {
        public void onItemClickItemPickerUI(int var1, int var2, String var3);
    }
}

