/*
 * Decompiled with CFR 0.152.
 */
package com.dpizarro.uipicker.library.picker;

import android.content.Context;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.dpizarro.uipicker.library.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class PickerUIAdapter
extends ArrayAdapter<String> {
    private static final String EMPTY_STRING = "";
    private static final int ROTATION_CENTER = 0;
    private static final int ROTATION_TWICE_ABOVE = -25;
    private static final int ROTATION_FIRST = -50;
    private static final int ROTATION_BELOW = 25;
    private static final int ROTATION_TWICE_BELOW = 50;
    private static final int ROTATION_ABOVE_FAR = -55;
    private static final int ROTATION_BELOW_FAR = 55;
    private Context mContext;
    private List<String> items;
    private int centerPosition;
    private boolean itemsClickables = true;
    private SparseIntArray positionsNoClickables;
    private int mColorTextCenter = -1;
    private int mColorTextNoCenter = -1;
    private boolean isInEditMode = false;

    public PickerUIAdapter(Context context, int resource, List<String> items, int position, boolean itemsClickables, boolean isInEditMode) {
        super(context, resource, items);
        this.mContext = context;
        this.itemsClickables = itemsClickables;
        this.isInEditMode = isInEditMode;
        this.positionsNoClickables = new SparseIntArray(items.size());
        this.setItems(items, position);
        this.setPositonsNoClickables();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            LayoutInflater vi = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            convertView = vi.inflate(R.layout.pickerui_item, parent, false);
        }
        TextView textItem = (TextView)ViewHolder.get(convertView, R.id.tv_item);
        String option = this.items.get(position);
        textItem.setText((CharSequence)option);
        if (!this.isInEditMode) {
            this.setTextItemStyle(textItem, position);
        }
        return convertView;
    }

    private void setTextItemStyle(TextView textItem, int position) {
        if (position == this.centerPosition) {
            textItem.setTextAppearance(this.mContext, R.style.PickerUI_Center_Item);
            this.setTextCenterColor(textItem);
            textItem.setRotationX(0.0f);
            textItem.setAlpha(1.0f);
        } else if (position - 1 == this.centerPosition) {
            textItem.setTextAppearance(this.mContext, R.style.PickerUI_Near_Center_Item);
            this.setTextNoCenterColor(textItem);
            textItem.setRotationX(-25.0f);
            textItem.setAlpha(1.0f);
        } else if (position - 2 == this.centerPosition) {
            textItem.setTextAppearance(this.mContext, R.style.PickerUI_Far_Center_Item);
            this.setTextNoCenterColor(textItem);
            textItem.setRotationX(-50.0f);
            textItem.setAlpha(0.7f);
        } else if (position + 1 == this.centerPosition) {
            textItem.setTextAppearance(this.mContext, R.style.PickerUI_Near_Center_Item);
            this.setTextNoCenterColor(textItem);
            textItem.setRotationX(25.0f);
            textItem.setAlpha(1.0f);
        } else if (position + 2 == this.centerPosition) {
            textItem.setTextAppearance(this.mContext, R.style.PickerUI_Far_Center_Item);
            this.setTextNoCenterColor(textItem);
            textItem.setRotationX(50.0f);
            textItem.setAlpha(0.7f);
        } else {
            if (position < this.centerPosition) {
                textItem.setRotationX(55.0f);
            } else {
                textItem.setRotationX(-55.0f);
            }
            textItem.setTextAppearance(this.mContext, R.style.PickerUI_Small_Item);
        }
    }

    private void setTextCenterColor(TextView textItem) {
        if (this.mColorTextCenter != -1) {
            textItem.setTextColor(this.mColorTextCenter);
        }
    }

    private void setTextNoCenterColor(TextView textItem) {
        if (this.mColorTextNoCenter != -1) {
            textItem.setTextColor(this.mColorTextNoCenter);
        }
    }

    public void setColorTextCenter(int color2) {
        this.mColorTextCenter = color2;
    }

    public void setColorTextNoCenter(int color2) {
        this.mColorTextNoCenter = color2;
    }

    void setItems(List<String> rawItems, int position) {
        this.addEmptyRows(rawItems);
        this.centerPosition = position == -1 ? 2 : position + 2;
    }

    public void handleSelectEvent(int position) {
        this.centerPosition = position;
        this.notifyDataSetChanged();
    }

    public void setItemsClickables(boolean itemsClickables) {
        this.itemsClickables = itemsClickables;
    }

    private void setPositonsNoClickables() {
        this.positionsNoClickables.put(0, 0);
        this.positionsNoClickables.put(1, 1);
        this.positionsNoClickables.put(this.items.size() - 2, this.items.size() - 2);
        this.positionsNoClickables.put(this.items.size() - 1, this.items.size() - 1);
    }

    private void addEmptyRows(List<String> rawItems) {
        List<String> emptyRows = Arrays.asList(EMPTY_STRING, EMPTY_STRING);
        ArrayList<String> items = new ArrayList<String>();
        items.addAll(emptyRows);
        items.addAll(rawItems);
        items.addAll(emptyRows);
        this.items = items;
    }

    public int getCount() {
        return this.items.size();
    }

    public boolean isEnabled(int position) {
        if (!this.itemsClickables) {
            return false;
        }
        boolean isClickable = this.positionsNoClickables.get(position, -1) == -1;
        return isClickable && super.isEnabled(position);
    }

    public static class ViewHolder {
        public static <T extends View> T get(View view, int id2) {
            View childView;
            SparseArray viewHolder = (SparseArray)view.getTag();
            if (viewHolder == null) {
                viewHolder = new SparseArray();
                view.setTag((Object)viewHolder);
            }
            if ((childView = (View)viewHolder.get(id2)) == null) {
                childView = view.findViewById(id2);
                viewHolder.put(id2, (Object)childView);
            }
            return (T)childView;
        }
    }
}

