/*
 * Decompiled with CFR 0.152.
 */
package com.dpizarro.uipicker.library.picker;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.RelativeLayout;
import com.dpizarro.uipicker.library.R;
import com.dpizarro.uipicker.library.blur.PickerUIBlurHelper;
import com.dpizarro.uipicker.library.picker.PickerUIListView;
import com.dpizarro.uipicker.library.picker.PickerUISettings;
import java.util.Arrays;
import java.util.List;

public class PickerUI
extends RelativeLayout
implements PickerUIBlurHelper.BlurFinishedListener {
    private static final String LOG_TAG = PickerUI.class.getSimpleName();
    private boolean autoDismiss = PickerUISettings.DEFAULT_AUTO_DISMISS;
    private boolean itemsClickables = PickerUISettings.DEFAULT_ITEMS_CLICKABLES;
    private PickerUIItemClickListener mPickerUIListener;
    private PickerUIListView mPickerUIListView;
    private View mHiddenPanelPickerUI;
    private Context mContext;
    private List<String> items;
    private int position;
    private PickerUIBlurHelper mPickerUIBlurHelper;
    private int backgroundColorPanel;
    private int colorLines;
    private int mColorTextCenterListView;
    private int mColorTextNoCenterListView;
    private PickerUISettings mPickerUISettings;

    public PickerUI(Context context) {
        super(context);
        this.mContext = context;
        if (this.isInEditMode()) {
            this.createEditModeView();
        } else {
            this.createView(null);
        }
    }

    public PickerUI(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        if (this.isInEditMode()) {
            this.createEditModeView();
        } else {
            this.createView(attrs);
            this.getAttributes(attrs);
        }
    }

    public PickerUI(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        if (this.isInEditMode()) {
            this.createEditModeView();
        } else {
            this.createView(attrs);
            this.getAttributes(attrs);
        }
    }

    private void createEditModeView() {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        inflater.inflate(R.layout.pickerui, (ViewGroup)this, true);
    }

    private void createView(AttributeSet attrs) {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.pickerui, (ViewGroup)this, true);
        this.mHiddenPanelPickerUI = view.findViewById(R.id.hidden_panel);
        this.mPickerUIListView = (PickerUIListView)view.findViewById(R.id.picker_ui_listview);
        this.setItemsClickables(this.itemsClickables);
        this.mPickerUIBlurHelper = new PickerUIBlurHelper(this.mContext, attrs);
        this.mPickerUIBlurHelper.setBlurFinishedListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAttributes(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.PickerUI, 0, 0);
        if (typedArray != null) {
            try {
                this.autoDismiss = typedArray.getBoolean(R.styleable.PickerUI_autoDismiss, PickerUISettings.DEFAULT_AUTO_DISMISS);
                this.itemsClickables = typedArray.getBoolean(R.styleable.PickerUI_itemsClickables, PickerUISettings.DEFAULT_ITEMS_CLICKABLES);
                this.backgroundColorPanel = typedArray.getColor(R.styleable.PickerUI_backgroundColor, this.getResources().getColor(R.color.background_panel_pickerui));
                this.colorLines = typedArray.getColor(R.styleable.PickerUI_linesCenterColor, this.getResources().getColor(R.color.lines_panel_pickerui));
                this.mColorTextCenterListView = typedArray.getColor(R.styleable.PickerUI_textCenterColor, this.getResources().getColor(R.color.text_center_pickerui));
                this.mColorTextNoCenterListView = typedArray.getColor(R.styleable.PickerUI_textNoCenterColor, this.getResources().getColor(R.color.text_no_center_pickerui));
                int idItems = typedArray.getResourceId(R.styleable.PickerUI_entries, -1);
                if (idItems != -1) {
                    this.setItems(this.mContext, Arrays.asList(this.getResources().getStringArray(idItems)));
                }
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"Error while creating the view PickerUI: ", (Throwable)e);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void slide() {
        int position = 0;
        if (this.items != null) {
            position = this.items.size() / 2;
        }
        this.slide(position);
    }

    public void slide(int position) {
        if (!this.isPanelShown()) {
            this.slideUp(position);
        } else {
            this.hidePanelPickerUI();
        }
    }

    public void slide(SLIDE slide) {
        if (slide == SLIDE.UP) {
            if (!this.isPanelShown()) {
                int position = 0;
                if (this.items != null) {
                    position = this.items.size() / 2;
                }
                this.slideUp(position);
            }
        } else {
            this.hidePanelPickerUI();
        }
    }

    private void slideUp(int position) {
        this.position = position;
        this.mPickerUIBlurHelper.render();
    }

    private void hidePanelPickerUI() {
        Animation bottomDown = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.picker_panel_bottom_down);
        this.mHiddenPanelPickerUI.startAnimation(bottomDown);
        bottomDown.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                PickerUI.this.mHiddenPanelPickerUI.setVisibility(8);
                PickerUI.this.mPickerUIBlurHelper.handleRecycle();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    public void setAutoDismiss(boolean autoDismiss) {
        this.autoDismiss = autoDismiss;
    }

    public void setBackgroundColorPanel(int color2) {
        this.backgroundColorPanel = color2;
    }

    public void setLinesColor(int color2) {
        this.colorLines = color2;
    }

    public void setItemsClickables(boolean itemsClickables) {
        this.itemsClickables = itemsClickables;
        if (this.mPickerUIListView != null && this.mPickerUIListView.getPickerUIAdapter() != null) {
            this.mPickerUIListView.getPickerUIAdapter().setItemsClickables(itemsClickables);
        }
    }

    private void setTextColorsListView() {
        this.setColorTextCenter(this.mColorTextCenterListView);
        this.setColorTextNoCenter(this.mColorTextNoCenterListView);
    }

    public boolean isPanelShown() {
        return this.mHiddenPanelPickerUI.getVisibility() == 0;
    }

    public void setItems(Context context, List<String> items) {
        if (items != null) {
            this.setItems(context, items, 0, items.size() / 2);
        }
    }

    public void setItems(Context context, List<String> items, int which, int position) {
        if (items != null) {
            this.items = items;
            this.mPickerUIListView.setItems(context, items, which, position, this.itemsClickables);
            this.setTextColorsListView();
        }
    }

    @Override
    public void onBlurFinished(Bitmap bitmapWithBlur) {
        if (bitmapWithBlur != null) {
            this.mPickerUIBlurHelper.showBlurImage(bitmapWithBlur);
        }
        this.showPanelPickerUI();
    }

    public void setUseBlur(boolean useBlur) {
        if (this.mPickerUIBlurHelper != null) {
            this.mPickerUIBlurHelper.setUseBlur(useBlur);
        }
    }

    public void setUseRenderScript(boolean useRenderScript) {
        if (this.mPickerUIBlurHelper != null) {
            this.mPickerUIBlurHelper.setUseRenderScript(useRenderScript);
        }
    }

    public void setDownScaleFactor(float downScaleFactor) {
        if (this.mPickerUIBlurHelper != null) {
            this.mPickerUIBlurHelper.setDownScaleFactor(downScaleFactor);
        }
    }

    public void setBlurRadius(int radius) {
        if (this.mPickerUIBlurHelper != null) {
            this.mPickerUIBlurHelper.setBlurRadius(radius);
        }
    }

    public void setFilterColor(int filterColor) {
        if (this.mPickerUIBlurHelper != null) {
            this.mPickerUIBlurHelper.setFilterColor(filterColor);
        }
    }

    public void setColorTextCenter(int color2) {
        if (this.mPickerUIListView != null && this.mPickerUIListView.getPickerUIAdapter() != null) {
            int newColor;
            try {
                newColor = this.getResources().getColor(color2);
            }
            catch (Resources.NotFoundException e) {
                newColor = color2;
            }
            this.mColorTextCenterListView = newColor;
            this.mPickerUIListView.getPickerUIAdapter().setColorTextCenter(newColor);
        }
    }

    public void setColorTextNoCenter(int color2) {
        if (this.mPickerUIListView != null && this.mPickerUIListView.getPickerUIAdapter() != null) {
            int newColor;
            try {
                newColor = this.getResources().getColor(color2);
            }
            catch (Resources.NotFoundException e) {
                newColor = color2;
            }
            this.mColorTextNoCenterListView = newColor;
            this.mPickerUIListView.getPickerUIAdapter().setColorTextNoCenter(newColor);
        }
    }

    private void showPanelPickerUI() {
        this.mHiddenPanelPickerUI.setVisibility(0);
        this.setBackgroundPanel();
        this.setBackgroundLines();
        Animation bottomUp = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.picker_panel_bottom_up);
        this.mHiddenPanelPickerUI.startAnimation(bottomUp);
        bottomUp.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                if (PickerUI.this.mPickerUIListView != null && PickerUI.this.mPickerUIListView.getPickerUIAdapter() != null) {
                    PickerUI.this.mPickerUIListView.getPickerUIAdapter().handleSelectEvent(PickerUI.this.position + 2);
                    PickerUI.this.mPickerUIListView.setSelection(PickerUI.this.position);
                }
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void setBackgroundPanel() {
        int color2;
        try {
            color2 = this.getResources().getColor(this.backgroundColorPanel);
        }
        catch (Resources.NotFoundException e) {
            color2 = this.backgroundColorPanel;
        }
        this.mHiddenPanelPickerUI.setBackgroundColor(color2);
    }

    private void setBackgroundLines() {
        int color2;
        try {
            color2 = this.getResources().getColor(this.colorLines);
        }
        catch (Resources.NotFoundException e) {
            color2 = this.colorLines;
        }
        this.mHiddenPanelPickerUI.findViewById(R.id.picker_line_top).setBackgroundColor(color2);
        this.mHiddenPanelPickerUI.findViewById(R.id.picker_line_bottom).setBackgroundColor(color2);
    }

    public void setOnClickItemPickerUIListener(PickerUIItemClickListener listener) {
        this.mPickerUIListener = listener;
        this.mPickerUIListView.setOnClickItemPickerUIListener(new PickerUIListView.PickerUIItemClickListener(){

            @Override
            public void onItemClickItemPickerUI(int which, int position, String valueResult) {
                if (PickerUI.this.autoDismiss) {
                    PickerUI.this.slide(position);
                }
                if (PickerUI.this.mPickerUIListener == null) {
                    throw new IllegalStateException("You must assign a valid PickerUI.PickerUIItemClickListener first!");
                }
                PickerUI.this.mPickerUIListener.onItemClickPickerUI(which, position, valueResult);
            }
        });
    }

    public void setSettings(PickerUISettings pickerUISettings) {
        this.mPickerUISettings = pickerUISettings;
        this.setColorTextCenter(pickerUISettings.getColorTextCenter());
        this.setColorTextNoCenter(pickerUISettings.getColorTextNoCenter());
        this.setItems(this.mContext, pickerUISettings.getItems());
        this.setBackgroundColorPanel(pickerUISettings.getBackgroundColor());
        this.setLinesColor(pickerUISettings.getLinesColor());
        this.setItemsClickables(pickerUISettings.areItemsClickables());
        this.setUseBlur(pickerUISettings.isUseBlur());
        this.setUseRenderScript(pickerUISettings.isUseBlurRenderscript());
        this.setAutoDismiss(pickerUISettings.isAutoDismiss());
        this.setBlurRadius(pickerUISettings.getBlurRadius());
        this.setDownScaleFactor(pickerUISettings.getBlurDownScaleFactor());
        this.setFilterColor(pickerUISettings.getBlurFilterColor());
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putParcelable("stateSettings", (Parcelable)this.mPickerUISettings);
        bundle.putBoolean("stateIsPanelShown", this.isPanelShown());
        bundle.putInt("statePosition", this.mPickerUIListView.getItemInListCenter());
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            boolean stateIsPanelShown;
            Bundle bundle = (Bundle)state;
            PickerUISettings pickerUISettings = (PickerUISettings)bundle.getParcelable("stateSettings");
            if (pickerUISettings != null) {
                this.setSettings(pickerUISettings);
            }
            if (stateIsPanelShown = bundle.getBoolean("stateIsPanelShown")) {
                final int statePosition = bundle.getInt("statePosition");
                ViewTreeObserver observer = this.getViewTreeObserver();
                observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        PickerUI.this.slideUp(statePosition);
                        if (Build.VERSION.SDK_INT >= 16) {
                            PickerUI.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            PickerUI.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                });
            }
            state = bundle.getParcelable("instanceState");
        }
        super.onRestoreInstanceState(state);
    }

    public static interface PickerUIItemClickListener {
        public void onItemClickPickerUI(int var1, int var2, String var3);
    }

    public static enum SLIDE {
        UP,
        DOWN;

    }
}

