/*
 * Decompiled with CFR 0.152.
 */
package com.dpizarro.uipicker.library.blur;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.dpizarro.uipicker.library.R;
import com.dpizarro.uipicker.library.blur.PickerUIBlur;
import com.dpizarro.uipicker.library.blur.PickerUIBlurTask;

public class PickerUIBlurHelper {
    private static final String LOG_TAG = PickerUIBlurHelper.class.getSimpleName();
    private static float mDownScaleFactor = PickerUIBlur.DEFAULT_DOWNSCALE_FACTOR;
    private ImageView mBlurredImageView;
    private int mBlurRadius = PickerUIBlur.DEFAULT_BLUR_RADIUS;
    private ViewGroup mRootView;
    private Context mContext;
    private int mFilterColor = -1;
    private int mAlpha = PickerUIBlur.CONSTANT_DEFAULT_ALPHA;
    private boolean mUseBlur = PickerUIBlur.DEFAULT_USE_BLUR;
    private boolean mUseRenderScript = PickerUIBlur.DEFAULT_USE_BLUR_RENDERSCRIPT;
    private BlurFinishedListener mBlurFinishedListener;

    public PickerUIBlurHelper(Context context, AttributeSet attrs) {
        this.mContext = context;
        this.getAttributes(attrs);
        this.createImageViewBlur();
    }

    static Bitmap loadBitmapFromView(View view) {
        if (view != null && view.getWidth() > 0 && view.getHeight() > 0) {
            Bitmap b = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b);
            view.draw(c);
            return b;
        }
        return null;
    }

    static Bitmap downscaleBitmap(Bitmap bitmap) {
        int width = (int)((float)bitmap.getWidth() / mDownScaleFactor);
        int height = (int)((float)bitmap.getHeight() / mDownScaleFactor);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAttributes(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.PickerUI, 0, 0);
        if (typedArray != null) {
            try {
                this.mUseBlur = typedArray.getBoolean(R.styleable.PickerUI_blur, PickerUIBlur.DEFAULT_USE_BLUR);
                this.mBlurRadius = typedArray.getInteger(R.styleable.PickerUI_blur_radius, PickerUIBlur.DEFAULT_BLUR_RADIUS);
                mDownScaleFactor = typedArray.getFloat(R.styleable.PickerUI_blur_downScaleFactor, PickerUIBlur.DEFAULT_DOWNSCALE_FACTOR);
                this.mFilterColor = typedArray.getColor(R.styleable.PickerUI_blur_FilterColor, -1);
                this.mUseRenderScript = typedArray.getBoolean(R.styleable.PickerUI_blur_use_renderscript, PickerUIBlur.DEFAULT_USE_BLUR_RENDERSCRIPT);
            }
            catch (Exception e) {
                Log.e((String)LOG_TAG, (String)"Error while creating the view PickerUI with PickerUIBlurHelper: ", (Throwable)e);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void setDownScaleFactor(float downScaleFactor) {
        if (!PickerUIBlur.isValidDownscale(downScaleFactor)) {
            throw new IllegalArgumentException("Invalid downsampling");
        }
        mDownScaleFactor = downScaleFactor < 1.0f ? 1.0f : downScaleFactor;
    }

    public void setUseBlur(boolean useBlur) {
        this.mUseBlur = useBlur;
    }

    public void setUseRenderScript(boolean useRenderScript) {
        this.mUseRenderScript = useRenderScript;
    }

    public void setBlurRadius(int blurRadius) {
        if (!PickerUIBlur.isValidBlurRadius(blurRadius)) {
            throw new IllegalArgumentException("Invalid blur radius");
        }
        this.mBlurRadius = blurRadius < 1 ? 1 : blurRadius;
    }

    private void setAlpha(View view, float alpha, long durationMillis) {
        if (Build.VERSION.SDK_INT < 11) {
            AlphaAnimation animation = new AlphaAnimation(alpha, alpha);
            animation.setDuration(durationMillis);
            animation.setFillAfter(true);
            view.startAnimation((Animation)animation);
        } else {
            view.setAlpha(alpha);
        }
    }

    public void setFilterColor(int filterColor) {
        this.mFilterColor = filterColor;
    }

    private void changeBitmapColor(Bitmap sourceBitmap, ImageView image, int color) {
        Bitmap resultBitmap = Bitmap.createBitmap((Bitmap)sourceBitmap, (int)0, (int)0, (int)(sourceBitmap.getWidth() - 1), (int)(sourceBitmap.getHeight() - 1));
        Paint p = new Paint();
        PorterDuffColorFilter filter = new PorterDuffColorFilter(color, PorterDuff.Mode.OVERLAY);
        p.setColorFilter((ColorFilter)filter);
        image.setImageBitmap(resultBitmap);
        Canvas canvas = new Canvas(resultBitmap);
        canvas.drawBitmap(resultBitmap, 0.0f, 0.0f, p);
    }

    void setBackground(Bitmap blurBitmap) {
        BitmapDrawable bd = new BitmapDrawable(this.mContext.getResources(), blurBitmap);
        bd.setAlpha(this.mAlpha);
        if (this.mFilterColor != -1) {
            this.changeBitmapColor(bd.getBitmap(), this.mBlurredImageView, this.mFilterColor);
        } else {
            this.mBlurredImageView.setImageBitmap(blurBitmap);
        }
    }

    public void showBlurImage(Bitmap bitmapWithBlur) {
        if (this.mUseBlur) {
            this.mBlurredImageView.setImageBitmap(null);
            this.mBlurredImageView.setVisibility(0);
            this.setBackground(bitmapWithBlur);
        }
    }

    public void handleRecycle() {
        if (this.mUseBlur) {
            BitmapDrawable bitmapDrawable;
            Bitmap bitmap;
            Drawable drawable = this.mBlurredImageView.getDrawable();
            if (drawable instanceof BitmapDrawable && (bitmap = (bitmapDrawable = (BitmapDrawable)drawable).getBitmap()) != null) {
                bitmap.recycle();
            }
            this.mBlurredImageView.setVisibility(8);
            this.mBlurredImageView.setImageBitmap(null);
        }
    }

    private void createImageViewBlur() {
        if (this.mUseBlur) {
            this.mRootView = (ViewGroup)((Activity)this.mContext).getWindow().getDecorView().findViewById(0x1020002);
            this.mBlurredImageView = new ImageView(this.mContext);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            Log.d((String)"YYYYY width", (String)("" + this.mRootView.getWidth()));
            Log.d((String)"YYYYY height", (String)("" + this.mRootView.getHeight()));
            this.mBlurredImageView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mBlurredImageView.setClickable(false);
            this.mBlurredImageView.setVisibility(8);
            this.mBlurredImageView.setScaleType(ImageView.ScaleType.FIT_XY);
            this.mRootView.post(new Runnable(){

                @Override
                public void run() {
                    ((ViewGroup)PickerUIBlurHelper.this.mRootView.getChildAt(0)).addView((View)PickerUIBlurHelper.this.mBlurredImageView, PickerUIBlurHelper.this.mRootView.getChildCount());
                }
            });
        }
    }

    public void render() {
        if (this.mUseBlur) {
            PickerUIBlurTask pickerUIBlurTask = new PickerUIBlurTask((Activity)this.mContext, this.mBlurRadius, this.mBlurFinishedListener, this.mUseRenderScript);
            pickerUIBlurTask.execute(new Void[0]);
        } else {
            if (this.mBlurFinishedListener == null) {
                throw new IllegalStateException("You must assign a valid BlurFinishedListener first!");
            }
            this.mBlurFinishedListener.onBlurFinished(null);
        }
    }

    public void setBlurFinishedListener(BlurFinishedListener listener) {
        this.mBlurFinishedListener = listener;
    }

    public static interface BlurFinishedListener {
        public void onBlurFinished(Bitmap var1);
    }
}

