/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.text.utils;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.davidmoten.text.utils.CharSequenceConcatRightTrim;
import org.davidmoten.text.utils.CharSequenceReader;
import org.davidmoten.text.utils.IORuntimeException;
import org.davidmoten.text.utils.LineConsumer;
import org.davidmoten.text.utils.StringBuilder2;

public final class WordWrap {
    private static final String SPECIAL_WORD_CHARS = "\"'\u2018\u2019\u201c\u201d?./!,;:_";
    public static final Set<Character> SPECIAL_WORD_CHARS_SET_DEFAULT = WordWrap.toSet("\"'\u2018\u2019\u201c\u201d?./!,;:_");
    private static final Function<CharSequence, Number> STRING_WIDTH_DEFAULT = s -> s.length();
    private static final String PUNCTUATION = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";

    private WordWrap() {
    }

    public static Builder from(Reader reader) {
        return WordWrap.from(reader, false);
    }

    public static Builder fromClasspathUtf8(String resource) {
        return WordWrap.fromClasspath(resource, StandardCharsets.UTF_8);
    }

    public static Builder fromClasspath(String resource, Charset charset) {
        return new Builder(new BufferedReader(new InputStreamReader(WordWrap.class.getResourceAsStream(resource), charset)), true);
    }

    public static Builder from(CharSequence text) {
        return WordWrap.from(new BufferedReader(new CharSequenceReader(text)), true);
    }

    public static Builder fromUtf8(InputStream in) {
        return WordWrap.from(in, StandardCharsets.UTF_8);
    }

    public static Builder from(InputStream in, Charset charset) {
        return WordWrap.from(new BufferedReader(new InputStreamReader(in, charset)));
    }

    public static Builder from(File file, Charset charset) {
        try {
            return WordWrap.from(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset)), true);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    private static Builder from(Reader reader, boolean close) {
        return new Builder(reader, close);
    }

    @VisibleForTesting
    static void close(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static Set<Character> toSet(String chars) {
        HashSet<Character> set = new HashSet<Character>();
        for (int i = 0; i < chars.length(); ++i) {
            set.add(Character.valueOf(chars.charAt(i)));
        }
        return set;
    }

    static void wordWrap(Reader in, final Writer out, final String newLine, Number maxWidth, Function<? super CharSequence, ? extends Number> stringWidth, Set<Character> extraWordChars, boolean insertHyphens, boolean breakWords) throws IOException {
        LineConsumer consumer = new LineConsumer(){

            @Override
            public void write(String s) throws IOException {
                out.write(s);
            }

            @Override
            public void write(char[] chars, int start, int length) throws IOException {
                out.write(chars, start, length);
            }

            @Override
            public void writeNewLine() throws IOException {
                out.write(newLine);
            }
        };
        WordWrap.wordWrap(in, consumer, maxWidth, stringWidth, extraWordChars, insertHyphens, breakWords);
    }

    static void wordWrap(Reader in, LineConsumer out, Number maxWidth, Function<? super CharSequence, ? extends Number> stringWidth, Set<Character> extraWordChars, boolean insertHyphens, boolean breakWords) throws IOException {
        int c;
        StringBuilder2 line = new StringBuilder2();
        StringBuilder2 word = new StringBuilder2();
        CharSequence lineAndWordRightTrim = WordWrap.concatRightTrim(line, word);
        double maxWidthDouble = maxWidth.doubleValue();
        boolean broken = false;
        boolean isWordCharacter = false;
        boolean previousWasPunctuation = false;
        while ((c = in.read()) != -1) {
            char ch = (char)c;
            boolean bl = isWordCharacter = Character.isLetter(ch) || extraWordChars.contains(Character.valueOf(ch));
            if (ch == '\n') {
                line.append(word);
                if (WordWrap.tooLong(stringWidth, line, maxWidthDouble)) {
                    line.rightTrim();
                }
                if (!WordWrap.isWhitespace(line)) {
                    out.write(line.internalArray(), 0, line.length());
                }
                out.writeNewLine();
                word.setLength(0);
                line.setLength(0);
                broken = false;
            } else if (ch != '\r') {
                if (isWordCharacter && !previousWasPunctuation) {
                    word.append(ch);
                    if (broken && line.length() == 0) {
                        WordWrap.leftTrim(word);
                    }
                    if (WordWrap.tooLong(stringWidth, lineAndWordRightTrim, maxWidthDouble)) {
                        if (line.length() > 0) {
                            WordWrap.writeLine(out, line);
                            WordWrap.leftTrim(word);
                            if (WordWrap.tooLong(stringWidth, word, maxWidthDouble)) {
                                if (breakWords) {
                                    WordWrap.writeBrokenWord(out, word, insertHyphens);
                                } else {
                                    broken = true;
                                }
                            } else {
                                broken = true;
                            }
                        } else if (breakWords) {
                            WordWrap.writeBrokenWord(out, word, insertHyphens);
                        } else {
                            broken = true;
                        }
                    }
                } else {
                    if (word.length() > 0 && !WordWrap.isWhitespace(word)) {
                        WordWrap.appendWordToLine(line, word);
                        if (broken) {
                            WordWrap.leftTrim(line);
                        }
                    }
                    word.append(ch);
                    if (WordWrap.tooLong(stringWidth, lineAndWordRightTrim, maxWidthDouble)) {
                        Preconditions.checkArgument((line.length() > 0 ? 1 : 0) != 0, (String)"line length was zero. If this happens please contribute unit test that provokes this failure to the project!");
                        if (!WordWrap.isWhitespace(line)) {
                            WordWrap.writeLine(out, line);
                        } else {
                            line.setLength(0);
                        }
                        broken = true;
                    }
                }
            }
            previousWasPunctuation = WordWrap.isPunctuation(ch) && !extraWordChars.contains(Character.valueOf(ch));
        }
        if (line.length() > 0) {
            String s = line.toString() + word.toString();
            if (broken) {
                s = WordWrap.leftTrim(s);
            }
            out.write(s);
        } else {
            if (broken) {
                WordWrap.leftTrim(word);
            }
            if (!WordWrap.isWhitespace(word)) {
                out.write(word.internalArray(), 0, word.length());
            }
        }
    }

    private static CharSequence concatRightTrim(CharSequence a, CharSequence b) {
        return new CharSequenceConcatRightTrim(a, b);
    }

    private static boolean isPunctuation(char ch) {
        return PUNCTUATION.indexOf(ch) != -1;
    }

    private static boolean tooLong(Function<? super CharSequence, ? extends Number> stringWidth, CharSequence s, double maxWidthDouble) {
        return stringWidth.apply(s).doubleValue() > maxWidthDouble;
    }

    @VisibleForTesting
    static CharSequence rightTrim(CharSequence s) {
        int i;
        for (i = s.length(); i > 0 && Character.isWhitespace(s.charAt(i - 1)); --i) {
        }
        if (i != s.length()) {
            return s.subSequence(0, i);
        }
        return s;
    }

    static boolean isWhitespace(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static void leftTrim(StringBuilder2 word) {
        int i;
        for (i = 0; i < word.length() && Character.isWhitespace(word.charAt(i)); ++i) {
        }
        if (i < word.length() && i > 0) {
            word.delete(0, i);
        }
    }

    private static String leftTrim(String s) {
        StringBuilder2 b = new StringBuilder2(s);
        WordWrap.leftTrim(b);
        return b.toString();
    }

    private static void appendWordToLine(StringBuilder2 line, StringBuilder2 word) {
        line.append(word);
        word.setLength(0);
    }

    private static void writeBrokenWord(LineConsumer out, StringBuilder2 word, boolean insertHyphens) throws IOException {
        String x;
        if (insertHyphens && word.length() > 2 && !WordWrap.isWhitespace(x = word.substring(0, word.length() - 2))) {
            out.write(x);
            out.write("-");
            out.writeNewLine();
            word.delete(0, word.length() - 2);
        } else {
            String prefix = word.substring(0, word.length() - 1);
            if (!WordWrap.isWhitespace(prefix)) {
                out.write(prefix);
            }
            out.writeNewLine();
            word.delete(0, word.length() - 1);
        }
    }

    private static void writeLine(LineConsumer out, StringBuilder2 line) throws IOException {
        out.write(line.internalArray(), 0, line.length());
        out.writeNewLine();
        line.setLength(0);
    }

    static /* synthetic */ Function access$000() {
        return STRING_WIDTH_DEFAULT;
    }

    public static final class Builder {
        private final Reader reader;
        private final boolean closeReader;
        private Number maxWidth = 80;
        private Function<? super CharSequence, ? extends Number> stringWidth = WordWrap.access$000();
        private Set<Character> extraWordChars = SPECIAL_WORD_CHARS_SET_DEFAULT;
        private String newLine = "\n";
        private boolean insertHyphens = true;
        private boolean breakWords = true;

        Builder(Reader reader, boolean closeReader) {
            this.reader = reader;
            this.closeReader = closeReader;
        }

        public Builder maxWidth(Number maxWidth) {
            Preconditions.checkArgument((maxWidth.doubleValue() > 0.0 ? 1 : 0) != 0);
            this.maxWidth = maxWidth;
            return this;
        }

        public Builder stringWidth(Function<? super CharSequence, ? extends Number> stringWidth) {
            this.stringWidth = stringWidth;
            return this;
        }

        public Builder newLine(String newLine) {
            this.newLine = newLine;
            return this;
        }

        public Builder extraWordChars(Set<Character> extraWordChars) {
            this.extraWordChars = extraWordChars;
            return this;
        }

        public Builder extraWordChars(String extraWordChars) {
            return this.extraWordChars(WordWrap.toSet(extraWordChars));
        }

        public Builder includeExtraWordChars(String includeWordChars) {
            Set set = WordWrap.toSet(includeWordChars);
            this.extraWordChars.addAll(set);
            return this;
        }

        public Builder excludeExtraWordChars(String excludeWordChars) {
            Set set = WordWrap.toSet(excludeWordChars);
            this.extraWordChars.removeAll(set);
            return this;
        }

        public Builder insertHyphens(boolean insertHyphens) {
            this.insertHyphens = insertHyphens;
            return this;
        }

        public Builder breakWords(boolean breakWords) {
            this.breakWords = breakWords;
            return this;
        }

        public void wrap(Writer out) {
            try {
                WordWrap.wordWrap(this.reader, out, this.newLine, this.maxWidth, this.stringWidth, this.extraWordChars, this.insertHyphens, this.breakWords);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            finally {
                if (this.closeReader) {
                    WordWrap.close(this.reader);
                }
            }
        }

        public List<String> wrapToList() {
            final ArrayList<String> lines = new ArrayList<String>();
            final StringBuilder b = new StringBuilder();
            final boolean[] building = new boolean[1];
            this.wrap(new LineConsumer(){

                @Override
                public void write(char[] chars, int offset, int length) throws IOException {
                    building[0] = true;
                    b.append(chars, offset, length);
                }

                @Override
                public void writeNewLine() throws IOException {
                    lines.add(b.toString());
                    b.setLength(0);
                    building[0] = false;
                }
            });
            if (building[0]) {
                lines.add(b.toString());
            }
            return lines;
        }

        public void wrap(LineConsumer consumer) {
            try {
                WordWrap.wordWrap(this.reader, consumer, this.maxWidth, this.stringWidth, this.extraWordChars, this.insertHyphens, this.breakWords);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            finally {
                if (this.closeReader) {
                    WordWrap.close(this.reader);
                }
            }
        }

        public void wrap(File file, Charset charset) {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);){
                this.wrap(writer);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public void wrapUtf8(File file) {
            this.wrap(file, StandardCharsets.UTF_8);
        }

        public void wrapUtf8(String filename) {
            this.wrapUtf8(new File(filename));
        }

        public void wrap(String filename, Charset charset) {
            this.wrap(new File(filename), charset);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String wrap() {
            try (StringWriter out = new StringWriter();){
                this.wrap(out);
                String string = out.toString();
                return string;
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
    }
}

