/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.util;

import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;

public final class TextUtils {
    private TextUtils() {
    }

    public static String joinTogether(Collection<String> items, String delim) {
        StringBuffer ret = new StringBuffer();
        Iterator<String> it = items.iterator();
        while (it.hasNext()) {
            ret.append(it.next());
            if (!it.hasNext()) continue;
            ret.append(delim);
        }
        return ret.toString();
    }

    public static byte[] getBytes(String str, String charset) {
        try {
            return str.getBytes(charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(charset, ex);
        }
    }

    public static byte[] getAsciiBytes(String str) {
        return TextUtils.getBytes(str, "US-ASCII");
    }

    @VisibleForTesting
    static String getString(byte[] bytes, String charset) {
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getStringUtf8(byte[] bytes) {
        return TextUtils.getString(bytes, "UTF-8");
    }
}

