/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.util;

public final class HexUtils {
    private static final char[] LOOKUP_TABLE = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF".toCharArray();

    private HexUtils() {
    }

    public static final String toHex(byte[] data) {
        return HexUtils.toHex(data, 0, data.length, null);
    }

    public static final String toHex(byte[] data, char sep) {
        return HexUtils.toHex(data, 0, data.length, Character.valueOf(sep));
    }

    public static final String toHex(byte[] data, int off, int len) {
        return HexUtils.toHex(data, off, len, null);
    }

    public static final String toHex(byte[] data, int off, int len, Character sep) {
        if (len < 0) {
            throw new IllegalArgumentException("Invalid negative len " + len);
        }
        if (data.length < off) {
            throw new IllegalArgumentException("Invalid offset outside array: offset " + off + " array length " + data.length);
        }
        int end = off + len;
        if (data.length < end) {
            throw new IllegalArgumentException("Invalid length outside array: offset " + off + " length " + len + " array length " + data.length);
        }
        if (len == 0) {
            return "";
        }
        char[] result = sep == null ? new char[len << 1] : new char[(len << 1) + len - 1];
        int i = 0;
        while (off < end) {
            int lookup = (data[off++] & 0xFF) << 1;
            result[i++] = LOOKUP_TABLE[lookup];
            result[i++] = LOOKUP_TABLE[lookup + 1];
            if (sep == null || off >= end) continue;
            result[i++] = sep.charValue();
        }
        return new String(result);
    }
}

