/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.internal;

import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.internal.Functions;
import java.util.Comparator;
import java.util.List;
import rx.functions.Func1;

public final class Comparators {
    public static final Comparator<ListPair<?>> overlapListPairComparator = Comparators.toComparator(Functions.overlapListPair);
    public static final Comparator<ListPair<?>> areaPairComparator = new Comparator<ListPair<?>>(){

        @Override
        public int compare(ListPair<?> p1, ListPair<?> p2) {
            return Float.compare(p1.areaSum(), p2.areaSum());
        }
    };

    private Comparators() {
    }

    public static <T extends HasGeometry> Comparator<HasGeometry> overlapAreaComparator(Rectangle r, List<T> list) {
        return Comparators.toComparator(Functions.overlapArea(r, list));
    }

    public static <T extends HasGeometry> Comparator<HasGeometry> areaIncreaseComparator(Rectangle r) {
        return Comparators.toComparator(Functions.areaIncrease(r));
    }

    public static Comparator<HasGeometry> areaComparator(final Rectangle r) {
        return new Comparator<HasGeometry>(){

            @Override
            public int compare(HasGeometry g1, HasGeometry g2) {
                return Float.compare(g1.geometry().mbr().add(r).area(), g2.geometry().mbr().add(r).area());
            }
        };
    }

    public static <R, T extends Comparable<T>> Comparator<R> toComparator(final Func1<R, T> function) {
        return new Comparator<R>(){

            @Override
            public int compare(R g1, R g2) {
                return ((Comparable)function.call(g1)).compareTo(function.call(g2));
            }
        };
    }

    public static <T> Comparator<T> compose(final Comparator<T> ... comparators) {
        return new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                for (Comparator comparator : comparators) {
                    int value = comparator.compare(t1, t2);
                    if (value == 0) continue;
                    return value;
                }
                return 0;
            }
        };
    }

    public static <T, S extends Geometry> Comparator<Entry<T, S>> ascendingDistance(final Rectangle r) {
        return new Comparator<Entry<T, S>>(){

            @Override
            public int compare(Entry<T, S> e1, Entry<T, S> e2) {
                return Double.compare(e1.geometry().distance(r), e2.geometry().distance(r));
            }
        };
    }
}

