/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.internal.util.ObjectsHelper;

final class RectangleImpl
implements Rectangle {
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;

    private RectangleImpl(float x1, float y1, float x2, float y2) {
        Preconditions.checkArgument((x2 >= x1 ? 1 : 0) != 0);
        Preconditions.checkArgument((y2 >= y1 ? 1 : 0) != 0);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    static Rectangle create(double x1, double y1, double x2, double y2) {
        return new RectangleImpl((float)x1, (float)y1, (float)x2, (float)y2);
    }

    static Rectangle create(float x1, float y1, float x2, float y2) {
        return new RectangleImpl(x1, y1, x2, y2);
    }

    @Override
    public float x1() {
        return this.x1;
    }

    @Override
    public float y1() {
        return this.y1;
    }

    @Override
    public float x2() {
        return this.x2;
    }

    @Override
    public float y2() {
        return this.y2;
    }

    @Override
    public float area() {
        return (this.x2 - this.x1) * (this.y2 - this.y1);
    }

    @Override
    public Rectangle add(Rectangle r) {
        return new RectangleImpl(RectangleImpl.min(this.x1, r.x1()), RectangleImpl.min(this.y1, r.y1()), RectangleImpl.max(this.x2, r.x2()), RectangleImpl.max(this.y2, r.y2()));
    }

    @Override
    public boolean contains(double x, double y) {
        return x >= (double)this.x1 && x <= (double)this.x2 && y >= (double)this.y1 && y <= (double)this.y2;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return RectangleImpl.intersects(this.x1, this.y1, this.x2, this.y2, r.x1(), r.y1(), r.x2(), r.y2());
    }

    @Override
    public double distance(Rectangle r) {
        return RectangleImpl.distance(this.x1, this.y1, this.x2, this.y2, r.x1(), r.y1(), r.x2(), r.y2());
    }

    public static double distance(float x1, float y1, float x2, float y2, float a1, float b1, float a2, float b2) {
        if (RectangleImpl.intersects(x1, y1, x2, y2, a1, b1, a2, b2)) {
            return 0.0;
        }
        boolean xyMostLeft = x1 < a1;
        float mostLeftX1 = xyMostLeft ? x1 : a1;
        float mostRightX1 = xyMostLeft ? a1 : x1;
        float mostLeftX2 = xyMostLeft ? x2 : a2;
        double xDifference = RectangleImpl.max(0.0f, mostLeftX1 == mostRightX1 ? 0.0f : mostRightX1 - mostLeftX2);
        boolean xyMostDown = y1 < b1;
        float mostDownY1 = xyMostDown ? y1 : b1;
        float mostUpY1 = xyMostDown ? b1 : y1;
        float mostDownY2 = xyMostDown ? y2 : b2;
        double yDifference = RectangleImpl.max(0.0f, mostDownY1 == mostUpY1 ? 0.0f : mostUpY1 - mostDownY2);
        return Math.sqrt(xDifference * xDifference + yDifference * yDifference);
    }

    private static boolean intersects(float x1, float y1, float x2, float y2, float a1, float b1, float a2, float b2) {
        return x1 <= a2 && a1 <= x2 && y1 <= b2 && b1 <= y2;
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    public String toString() {
        return "Rectangle [x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + "]";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.x1), Float.valueOf(this.y1), Float.valueOf(this.x2), Float.valueOf(this.y2)});
    }

    public boolean equals(Object obj) {
        Optional<RectangleImpl> other = ObjectsHelper.asClass(obj, RectangleImpl.class);
        if (other.isPresent()) {
            return Objects.equal((Object)Float.valueOf(this.x1), (Object)Float.valueOf(((RectangleImpl)other.get()).x1)) && Objects.equal((Object)Float.valueOf(this.x2), (Object)Float.valueOf(((RectangleImpl)other.get()).x2)) && Objects.equal((Object)Float.valueOf(this.y1), (Object)Float.valueOf(((RectangleImpl)other.get()).y1)) && Objects.equal((Object)Float.valueOf(this.y2), (Object)Float.valueOf(((RectangleImpl)other.get()).y2));
        }
        return false;
    }

    @Override
    public float intersectionArea(Rectangle r) {
        if (!this.intersects(r)) {
            return 0.0f;
        }
        return RectangleImpl.create(RectangleImpl.max(this.x1, r.x1()), RectangleImpl.max(this.y1, r.y1()), RectangleImpl.min(this.x2, r.x2()), RectangleImpl.min(this.y2, r.y2())).area();
    }

    @Override
    public float perimeter() {
        return 2.0f * (this.x2 - this.x1) + 2.0f * (this.y2 - this.y1);
    }

    @Override
    public Geometry geometry() {
        return this;
    }

    private static float max(float a, float b) {
        if (a < b) {
            return b;
        }
        return a;
    }

    private static float min(float a, float b) {
        if (a < b) {
            return a;
        }
        return b;
    }
}

