/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Serializer;
import com.github.davidmoten.rtree.fbs.SerializerFlatBuffers;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rx.Functions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import rx.functions.Func1;

public final class Serializers {
    private Serializers() {
    }

    public static <T, S extends Geometry> SerializerFlatBuffersBuilder flatBuffers() {
        return new SerializerFlatBuffersBuilder();
    }

    private static Func1<String, byte[]> createStringSerializer(final Charset charset) {
        return new Func1<String, byte[]>(){

            public byte[] call(String s) {
                return s.toString().getBytes(charset);
            }
        };
    }

    private static <T> Func1<byte[], String> createStringDeserializer(final Charset charset) {
        return new Func1<byte[], String>(){

            public String call(byte[] bytes) {
                return new String(bytes, charset);
            }
        };
    }

    private static Func1<Serializable, byte[]> javaIoSerializer() {
        return new Func1<Serializable, byte[]>(){

            public byte[] call(Serializable o) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ObjectOutputStream oos = null;
                try {
                    oos = new ObjectOutputStream(bytes);
                    oos.writeObject(o);
                    oos.close();
                    byte[] byArray = bytes.toByteArray();
                    return byArray;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
    }

    private static Func1<byte[], Serializable> javaIoDeserializer() {
        return new Func1<byte[], Serializable>(){

            public Serializable call(byte[] bytes) {
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream(is);
                    Serializable serializable = (Serializable)ois.readObject();
                    return serializable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
    }

    public static final class SerializerFlatBuffersTypedBuilder<T> {
        private Func1<T, byte[]> serializer;
        private Func1<byte[], T> deserializer;

        private SerializerFlatBuffersTypedBuilder(Func1<T, byte[]> serializer, Func1<byte[], T> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public SerializerFlatBuffersTypedBuilder<T> serializer(Func1<T, byte[]> serializer) {
            this.serializer = serializer;
            return this;
        }

        public SerializerFlatBuffersTypedBuilder<T> deserializer(Func1<byte[], T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public <S extends Geometry> Serializer<T, S> create() {
            if (this.serializer == null) {
                this.serializer = Serializers.javaIoSerializer();
            }
            if (this.deserializer == null) {
                this.deserializer = Serializers.javaIoDeserializer();
            }
            return SerializerFlatBuffers.create(this.serializer, this.deserializer);
        }
    }

    public static class SerializerFlatBuffersBuilder {
        private SerializerFlatBuffersBuilder() {
        }

        public <T> SerializerFlatBuffersTypedBuilder<T> serializer(Func1<T, byte[]> serializer) {
            return new SerializerFlatBuffersTypedBuilder(serializer, null);
        }

        public <T> SerializerFlatBuffersTypedBuilder<T> deserializer(Func1<byte[], T> deserializer) {
            return new SerializerFlatBuffersTypedBuilder(null, deserializer);
        }

        public <S extends Geometry> Serializer<String, S> string(Charset charset) {
            Func1 serializer = Serializers.createStringSerializer(charset);
            Func1 deserializer = Serializers.createStringDeserializer(charset);
            return new SerializerFlatBuffersTypedBuilder(serializer, deserializer).create();
        }

        public <T extends Serializable, S extends Geometry> Serializer<T, S> javaIo() {
            Func1 serializer = Serializers.javaIoSerializer();
            Func1 deserializer = Serializers.javaIoDeserializer();
            return new SerializerFlatBuffersTypedBuilder(serializer, deserializer).create();
        }

        public <S extends Geometry> Serializer<String, S> utf8() {
            return this.string(Charset.forName("UTF-8"));
        }

        public <S extends Geometry> Serializer<byte[], S> bytes() {
            Func1 serializer = Functions.identity();
            Func1 deserializer = Functions.identity();
            return new SerializerFlatBuffersTypedBuilder(serializer, deserializer).create();
        }
    }
}

