/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.operators;

import com.google.common.collect.MinMaxPriorityQueue;
import java.util.Comparator;
import rx.Observable;
import rx.Subscriber;

public final class OperatorBoundedPriorityQueue<T>
implements Observable.Operator<T, T> {
    private final int maximumSize;
    private final Comparator<? super T> comparator;

    public OperatorBoundedPriorityQueue(int maximumSize, Comparator<? super T> comparator) {
        this.maximumSize = maximumSize;
        this.comparator = comparator;
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final MinMaxPriorityQueue q = MinMaxPriorityQueue.orderedBy(this.comparator).maximumSize(this.maximumSize).create();
        return new Subscriber<T>(child){

            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            public void onCompleted() {
                Object t;
                while ((t = q.poll()) != null) {
                    if (!this.isUnsubscribed()) {
                        child.onNext(t);
                        continue;
                    }
                    return;
                }
                if (this.isUnsubscribed()) {
                    return;
                }
                child.onCompleted();
            }

            public void onError(Throwable t) {
                if (!this.isUnsubscribed()) {
                    child.onError(t);
                }
            }

            public void onNext(T t) {
                if (!this.isUnsubscribed()) {
                    q.add(t);
                }
            }
        };
    }
}

