/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Comparators;
import com.github.davidmoten.rtree.Splitter;
import com.github.davidmoten.rtree.geometry.HasGeometry;
import com.github.davidmoten.rtree.geometry.ListPair;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.functions.Func1;

public final class SplitterRStar
implements Splitter {
    private final Comparator<ListPair<?>> comparator = Comparators.compose(Comparators.overlapListPairComparator, Comparators.areaPairComparator);
    private static final List<SortType> sortTypes = Collections.unmodifiableList(Arrays.asList(SortType.values()));
    private static Comparator<HasGeometry> INCREASING_X_LOWER = new Comparator<HasGeometry>(){

        @Override
        public int compare(HasGeometry n1, HasGeometry n2) {
            return Float.valueOf(n1.geometry().mbr().x1()).compareTo(Float.valueOf(n2.geometry().mbr().x1()));
        }
    };
    private static Comparator<HasGeometry> INCREASING_X_UPPER = new Comparator<HasGeometry>(){

        @Override
        public int compare(HasGeometry n1, HasGeometry n2) {
            return Float.valueOf(n1.geometry().mbr().x2()).compareTo(Float.valueOf(n2.geometry().mbr().x2()));
        }
    };
    private static Comparator<HasGeometry> INCREASING_Y_LOWER = new Comparator<HasGeometry>(){

        @Override
        public int compare(HasGeometry n1, HasGeometry n2) {
            return Float.valueOf(n1.geometry().mbr().y1()).compareTo(Float.valueOf(n2.geometry().mbr().y1()));
        }
    };
    private static Comparator<HasGeometry> INCREASING_Y_UPPER = new Comparator<HasGeometry>(){

        @Override
        public int compare(HasGeometry n1, HasGeometry n2) {
            return Float.valueOf(n1.geometry().mbr().y2()).compareTo(Float.valueOf(n2.geometry().mbr().y2()));
        }
    };

    @Override
    public <T extends HasGeometry> ListPair<T> split(List<T> items, int minSize) {
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0);
        HashMap<SortType, List<ListPair<T>>> map = new HashMap<SortType, List<ListPair<T>>>(5, 1.0f);
        map.put(SortType.X_LOWER, SplitterRStar.getPairs(minSize, SplitterRStar.sort(items, INCREASING_X_LOWER)));
        map.put(SortType.X_UPPER, SplitterRStar.getPairs(minSize, SplitterRStar.sort(items, INCREASING_X_UPPER)));
        map.put(SortType.Y_LOWER, SplitterRStar.getPairs(minSize, SplitterRStar.sort(items, INCREASING_Y_LOWER)));
        map.put(SortType.Y_UPPER, SplitterRStar.getPairs(minSize, SplitterRStar.sort(items, INCREASING_Y_UPPER)));
        SortType leastMarginSumSortType = Collections.min(sortTypes, SplitterRStar.marginSumComparator(map));
        List pairs = (List)map.get((Object)leastMarginSumSortType);
        return Collections.min(pairs, this.comparator);
    }

    private static <T extends HasGeometry> Comparator<SortType> marginSumComparator(final Map<SortType, List<ListPair<T>>> map) {
        return Comparators.toComparator(new Func1<SortType, Double>(){

            public Double call(SortType sortType) {
                return SplitterRStar.marginValueSum((List)map.get((Object)sortType));
            }
        });
    }

    private static <T extends HasGeometry> float marginValueSum(List<ListPair<T>> list) {
        float sum = 0.0f;
        for (ListPair<T> p : list) {
            sum += p.marginSum();
        }
        return sum;
    }

    @VisibleForTesting
    static <T extends HasGeometry> List<ListPair<T>> getPairs(int minSize, List<T> list) {
        ArrayList<ListPair<T>> pairs = new ArrayList<ListPair<T>>(list.size() - 2 * minSize + 1);
        for (int i = minSize; i < list.size() - minSize + 1; ++i) {
            List<T> list1 = list.subList(0, i);
            List<T> list2 = list.subList(i, list.size());
            ListPair<T> pair = new ListPair<T>(list1, list2);
            pairs.add(pair);
        }
        return pairs;
    }

    private static <T extends HasGeometry> List<T> sort(List<T> items, Comparator<HasGeometry> comparator) {
        ArrayList<T> list = new ArrayList<T>(items);
        Collections.sort(list, comparator);
        return list;
    }

    private static enum SortType {
        X_LOWER,
        X_UPPER,
        Y_LOWER,
        Y_UPPER;

    }
}

