/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Leaf;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NodePosition;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.util.ImmutableStack;
import rx.Subscriber;
import rx.functions.Func1;

final class Backpressure {
    private Backpressure() {
    }

    static <T, S extends Geometry> ImmutableStack<NodePosition<T, S>> search(Func1<? super Geometry, Boolean> condition, Subscriber<? super Entry<T, S>> subscriber, ImmutableStack<NodePosition<T, S>> stack, long request) {
        StackAndRequest<NodePosition<T, S>> state = StackAndRequest.create(stack, request);
        return Backpressure.searchAndReturnStack(condition, subscriber, state);
    }

    private static <S extends Geometry, T> ImmutableStack<NodePosition<T, S>> searchAndReturnStack(Func1<? super Geometry, Boolean> condition, Subscriber<? super Entry<T, S>> subscriber, StackAndRequest<NodePosition<T, S>> state) {
        while (!((StackAndRequest)state).stack.isEmpty()) {
            NodePosition np = (NodePosition)((StackAndRequest)state).stack.peek();
            if (subscriber.isUnsubscribed()) {
                return ImmutableStack.empty();
            }
            if (((StackAndRequest)state).request == 0L) {
                return ((StackAndRequest)state).stack;
            }
            if (np.position() == np.node().count()) {
                state = StackAndRequest.create(Backpressure.searchAfterLastInNode(((StackAndRequest)state).stack), ((StackAndRequest)state).request);
                continue;
            }
            if (np.node() instanceof NonLeaf) {
                state = StackAndRequest.create(Backpressure.searchNonLeaf(condition, ((StackAndRequest)state).stack, np), ((StackAndRequest)state).request);
                continue;
            }
            state = Backpressure.searchLeaf(condition, subscriber, state, np);
        }
        return ((StackAndRequest)state).stack;
    }

    private static <T, S extends Geometry> StackAndRequest<NodePosition<T, S>> searchLeaf(Func1<? super Geometry, Boolean> condition, Subscriber<? super Entry<T, S>> subscriber, StackAndRequest<NodePosition<T, S>> state, NodePosition<T, S> np) {
        long nextRequest;
        Entry entry = ((Leaf)np.node()).entries().get(np.position());
        if (((Boolean)condition.call(entry.geometry())).booleanValue()) {
            subscriber.onNext(entry);
            nextRequest = ((StackAndRequest)state).request - 1L;
        } else {
            nextRequest = ((StackAndRequest)state).request;
        }
        return StackAndRequest.create(((StackAndRequest)state).stack.pop().push(np.nextPosition()), nextRequest);
    }

    private static <S extends Geometry, T> ImmutableStack<NodePosition<T, S>> searchAfterLastInNode(ImmutableStack<NodePosition<T, S>> stack) {
        ImmutableStack<NodePosition<NodePosition<T, S>, S>> stack2 = stack.pop();
        if (stack2.isEmpty()) {
            stack = stack2;
        } else {
            NodePosition<NodePosition<T, S>, S> previous = stack2.peek();
            stack = stack2.pop().push(previous.nextPosition());
        }
        return stack;
    }

    private static <S extends Geometry, T> ImmutableStack<NodePosition<T, S>> searchNonLeaf(Func1<? super Geometry, Boolean> condition, ImmutableStack<NodePosition<T, S>> stack, NodePosition<T, S> np) {
        Node child = ((NonLeaf)np.node()).children().get(np.position());
        stack = (Boolean)condition.call((Object)child.geometry()) != false ? stack.push(new NodePosition(child, 0)) : stack.pop().push(np.nextPosition());
        return stack;
    }

    private static class StackAndRequest<T> {
        private final ImmutableStack<T> stack;
        private final long request;

        StackAndRequest(ImmutableStack<T> stack, long request) {
            this.stack = stack;
            this.request = request;
        }

        static <T> StackAndRequest<T> create(ImmutableStack<T> stack, long request) {
            return new StackAndRequest<T>(stack, request);
        }
    }
}

