/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Context;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.Leaf;
import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.NonLeaf;
import com.github.davidmoten.rtree.OnSubscribeSearch;
import com.github.davidmoten.rtree.Selector;
import com.github.davidmoten.rtree.SelectorMinimalAreaIncrease;
import com.github.davidmoten.rtree.SelectorRStar;
import com.github.davidmoten.rtree.Splitter;
import com.github.davidmoten.rtree.SplitterQuadratic;
import com.github.davidmoten.rtree.SplitterRStar;
import com.github.davidmoten.rtree.Visualizer;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rx.operators.OperatorBoundedPriorityQueue;
import com.github.davidmoten.util.ImmutableStack;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Comparator;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public final class RTree<R> {
    private final ImmutableStack<NonLeaf<R>> emptyStack = ImmutableStack.empty();
    private final Optional<Node<R>> root;
    private final Context context;
    public static final int MAX_CHILDREN_DEFAULT = 32;
    private int size;
    public static final Func1<Geometry, Boolean> ALWAYS_TRUE = new Func1<Geometry, Boolean>(){

        public Boolean call(Geometry rectangle) {
            return true;
        }
    };

    private RTree(Optional<Node<R>> root, int size, Context context) {
        this.root = root;
        this.size = size;
        this.context = context;
    }

    private RTree(Node<R> root, int size, Context context) {
        this(Optional.of(root), size, context);
    }

    private RTree(Context context) {
        this(Optional.absent(), 0, context);
    }

    public static <T> RTree<T> create() {
        return new Builder().create();
    }

    public int calculateDepth() {
        return RTree.calculateDepth(this.root);
    }

    private static <R> int calculateDepth(Optional<Node<R>> root) {
        if (!root.isPresent()) {
            return 0;
        }
        return RTree.calculateDepth((Node)root.get(), 0);
    }

    private static <R> int calculateDepth(Node<R> node, int depth) {
        if (node instanceof Leaf) {
            return depth + 1;
        }
        return RTree.calculateDepth(((NonLeaf)node).children().get(0), depth + 1);
    }

    public static Builder minChildren(int minChildren) {
        return new Builder().minChildren(minChildren);
    }

    public static Builder maxChildren(int maxChildren) {
        return new Builder().maxChildren(maxChildren);
    }

    public static Builder splitter(Splitter splitter) {
        return new Builder().splitter(splitter);
    }

    public static Builder selector(Selector selector) {
        return new Builder().selector(selector);
    }

    public static Builder star() {
        return new Builder().star();
    }

    public RTree<R> add(Entry<R> entry) {
        if (this.root.isPresent()) {
            return new RTree<R>(((Node)this.root.get()).add(entry, this.emptyStack), this.size + 1, this.context);
        }
        return new RTree(new Leaf(Lists.newArrayList((Object[])new Entry[]{entry}), this.context), this.size + 1, this.context);
    }

    public RTree<R> add(R value, Geometry geometry) {
        return this.add(Entry.entry(value, geometry));
    }

    public RTree<R> add(Iterable<Entry<R>> entries) {
        RTree<R> tree = this;
        for (Entry<R> entry : entries) {
            tree = tree.add(entry);
        }
        return tree;
    }

    public Observable<RTree<R>> add(Observable<Entry<R>> entries) {
        return entries.scan((Object)this, new Func2<RTree<R>, Entry<R>, RTree<R>>(){

            public RTree<R> call(RTree<R> tree, Entry<R> entry) {
                return tree.add(entry);
            }
        });
    }

    public Observable<RTree<R>> delete(Observable<Entry<R>> entries) {
        return entries.scan((Object)this, new Func2<RTree<R>, Entry<R>, RTree<R>>(){

            public RTree<R> call(RTree<R> tree, Entry<R> entry) {
                return tree.delete(entry);
            }
        });
    }

    public RTree<R> delete(Iterable<Entry<R>> entries) {
        RTree<R> tree = this;
        for (Entry<R> entry : entries) {
            tree = tree.delete(entry);
        }
        return tree;
    }

    public RTree<R> delete(R value, Geometry geometry) {
        return this.delete(Entry.entry(value, geometry));
    }

    public RTree<R> delete(Entry<R> entry) {
        if (this.root.isPresent()) {
            Optional<Node<R>> newRoot = ((Node)this.root.get()).delete(entry, this.emptyStack);
            if (newRoot.equals(this.root)) {
                return this;
            }
            return new RTree<R>(newRoot, this.size - 1, this.context);
        }
        return this;
    }

    public Observable<Entry<R>> search(Func1<? super Geometry, Boolean> condition) {
        if (this.root.isPresent()) {
            return Observable.create(new OnSubscribeSearch((Node)this.root.get(), condition));
        }
        return Observable.empty();
    }

    public static final <S> Comparator<Entry<S>> ascendingDistance(final Rectangle r) {
        return new Comparator<Entry<S>>(){

            @Override
            public int compare(Entry<S> e1, Entry<S> e2) {
                return Double.valueOf(e1.geometry().distance(r)).compareTo(e2.geometry().distance(r));
            }
        };
    }

    public static Func1<Geometry, Boolean> intersects(final Rectangle r) {
        return new Func1<Geometry, Boolean>(){

            public Boolean call(Geometry g) {
                return g.distance(r) == 0.0;
            }
        };
    }

    public Observable<Entry<R>> search(Rectangle r) {
        return this.search(RTree.intersects(r));
    }

    public Observable<Entry<R>> search(final Rectangle r, final double maxDistance) {
        return this.search((Func1<Geometry, Boolean>)new Func1<Geometry, Boolean>(){

            public Boolean call(Geometry g) {
                return g.distance(r) < maxDistance;
            }
        });
    }

    public Observable<Entry<R>> nearest(Rectangle r, double maxDistance, int maxCount) {
        return this.search(r, maxDistance).lift(new OperatorBoundedPriorityQueue(maxCount, RTree.ascendingDistance(r)));
    }

    public Observable<Entry<R>> entries() {
        return this.search(ALWAYS_TRUE);
    }

    public Visualizer visualize(int width, int height, Rectangle view) {
        return new Visualizer(this, width, height, view);
    }

    public Visualizer visualize(int width, int height) {
        return new Visualizer(this, width, height, this.calculateMaxView(this));
    }

    private Rectangle calculateMaxView(RTree<R> tree) {
        return (Rectangle)((Optional)tree.entries().reduce((Object)Optional.absent(), new Func2<Optional<Rectangle>, Entry<R>, Optional<Rectangle>>(){

            public Optional<Rectangle> call(Optional<Rectangle> r, Entry<R> entry) {
                if (r.isPresent()) {
                    return Optional.of((Object)((Rectangle)r.get()).add(entry.geometry().mbr()));
                }
                return Optional.of((Object)entry.geometry().mbr());
            }
        }).toBlocking().single()).or((Object)new Rectangle(0.0f, 0.0f, 0.0f, 0.0f));
    }

    Optional<Node<R>> root() {
        return this.root;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public static class Builder {
        private static final double DEFAULT_FILLING_FACTOR = 0.4;
        private int maxChildren = 32;
        private Optional<Integer> minChildren = Optional.absent();
        private Splitter splitter = new SplitterQuadratic();
        private Selector selector = new SelectorMinimalAreaIncrease();

        private Builder() {
        }

        public Builder minChildren(int minChildren) {
            this.minChildren = Optional.of((Object)minChildren);
            return this;
        }

        public Builder maxChildren(int maxChildren) {
            this.maxChildren = maxChildren;
            return this;
        }

        public Builder splitter(Splitter splitter) {
            this.splitter = splitter;
            return this;
        }

        public <T> Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder star() {
            this.selector = new SelectorRStar();
            this.splitter = new SplitterRStar();
            return this;
        }

        public <S> RTree<S> create() {
            if (!this.minChildren.isPresent()) {
                this.minChildren = Optional.of((Object)((int)Math.round((double)this.maxChildren * 0.4)));
            }
            return new RTree(new Context((Integer)this.minChildren.get(), this.maxChildren, this.selector, this.splitter));
        }
    }
}

