/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.internal;

import com.github.davidmoten.rtree.internal.Line2D;

public final class RectangleUtil {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;
    private static final double PRECISION = 1.0E-8;

    private RectangleUtil() {
    }

    public static boolean rectangleIntersectsLine(double rectX, double rectY, double rectWidth, double rectHeight, double x1, double y1, double x2, double y2) {
        return RectangleUtil._rectangleIntersectsLine(rectX, rectY, rectWidth, rectHeight, x1, y1, x2, y2) || Line2D.linesIntersect(rectX, rectY, rectX + rectWidth, rectY + rectHeight, x1, y1, x2, y2);
    }

    private static boolean _rectangleIntersectsLine(double rectX, double rectY, double rectWidth, double rectHeight, double x1, double y1, double x2, double y2) {
        int out1;
        if (RectangleUtil.rectangleCornerOnSegment(rectX, rectY, rectWidth, rectHeight, x1, y1, x2, y2)) {
            return true;
        }
        int out2 = RectangleUtil.outcode(rectX, rectY, rectWidth, rectHeight, x2, y2);
        if (out2 == 0) {
            return true;
        }
        while ((out1 = RectangleUtil.outcode(rectX, rectY, rectWidth, rectHeight, x1, y1)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                double x = rectX;
                if ((out1 & 4) != 0) {
                    x += rectWidth;
                }
                y1 += (x - x1) * (y2 - y1) / (x2 - x1);
                x1 = x;
                continue;
            }
            double y = rectY;
            if ((out1 & 8) != 0) {
                y += rectHeight;
            }
            x1 += (y - y1) * (x2 - x1) / (y2 - y1);
            y1 = y;
        }
        return true;
    }

    private static boolean rectangleCornerOnSegment(double rectX, double rectY, double rectWidth, double rectHeight, double x1, double y1, double x2, double y2) {
        if (RectangleUtil.pointOnSegment(rectX, rectY, x1, y1, x2, y2)) {
            return true;
        }
        if (RectangleUtil.pointOnSegment(rectX + rectWidth, rectY, x1, y1, x2, y2)) {
            return true;
        }
        if (RectangleUtil.pointOnSegment(rectX, rectY + rectHeight, x1, y1, x2, y2)) {
            return true;
        }
        return RectangleUtil.pointOnSegment(rectX + rectWidth, rectY + rectHeight, x1, y1, x2, y2);
    }

    private static boolean pointOnSegment(double x, double y, double x1, double y1, double x2, double y2) {
        if (x < x1 || x > x2 || y < y1 || y > y2) {
            return false;
        }
        double v = (y2 - y1) * (x - x1) - (x2 - x1) * (y - y1);
        return Math.abs(v) < 1.0E-8;
    }

    private static int outcode(double rectX, double rectY, double rectWidth, double rectHeight, double x, double y) {
        int out = 0;
        if (rectWidth <= 0.0) {
            out |= 5;
        } else if (x < rectX) {
            out |= 1;
        } else if (x > rectX + rectWidth) {
            out |= 4;
        }
        if (rectHeight <= 0.0) {
            out |= 0xA;
        } else if (y < rectY) {
            out |= 2;
        } else if (y > rectY + rectHeight) {
            out |= 8;
        }
        return out;
    }
}

