/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree;

import com.github.davidmoten.rtree.Node;
import com.github.davidmoten.rtree.Selector;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.google.common.base.Optional;
import java.util.List;

public class SelectorMinimalAreaIncrease
implements Selector {
    @Override
    public <T> Node<T> select(Geometry g, List<? extends Node<T>> nodes) {
        return SelectorMinimalAreaIncrease.findLeastIncreaseInMbrArea(g.mbr(), nodes);
    }

    private static <T> Node<T> findLeastIncreaseInMbrArea(Rectangle r, List<? extends Node<T>> list) {
        Optional minDifference = Optional.absent();
        Optional minDiffItem = Optional.absent();
        for (Node<T> m : list) {
            double diff = m.geometry().mbr().add(r).area() - m.geometry().mbr().area();
            if (minDifference.isPresent() && !(diff < (Double)minDifference.get())) continue;
            minDifference = Optional.of((Object)diff);
            minDiffItem = Optional.of(m);
        }
        return (Node)minDiffItem.get();
    }
}

