/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.projection;

import java.util.ArrayList;
import java.util.List;

public class ProjectorBounds {
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;
    private final String srs;

    public String getSrs() {
        return this.srs;
    }

    public ProjectorBounds(String srs, double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.srs = srs;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getSizeX() {
        return this.maxX - this.minX;
    }

    public double getSizeY() {
        return this.maxY - this.minY;
    }

    public List<ProjectorBounds> splitHorizontally() {
        ArrayList<ProjectorBounds> list = new ArrayList<ProjectorBounds>();
        list.add(new ProjectorBounds(this.srs, this.minX, this.minY, this.minX + this.getSizeX() / 2.0, this.maxY));
        list.add(new ProjectorBounds(this.srs, this.minX + this.getSizeX() / 2.0, this.minY, this.maxX, this.maxY));
        return list;
    }

    public List<ProjectorBounds> splitVertically() {
        ArrayList<ProjectorBounds> list = new ArrayList<ProjectorBounds>();
        list.add(new ProjectorBounds(this.srs, this.minX, this.minY, this.maxX, this.minY + this.getSizeY() / 2.0));
        list.add(new ProjectorBounds(this.srs, this.minX, this.minY + this.getSizeY() / 2.0, this.maxX, this.maxY));
        return list;
    }

    public List<ProjectorBounds> quarter() {
        ArrayList<ProjectorBounds> list = new ArrayList<ProjectorBounds>();
        for (ProjectorBounds b : this.splitHorizontally()) {
            list.addAll(b.splitVertically());
        }
        return list;
    }

    public String toString() {
        return "ProjectorBounds [srs=" + this.srs + ", minX=" + this.minX + ", minY=" + this.minY + ", maxX=" + this.maxX + ", maxY=" + this.maxY + "]";
    }
}

