/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.wms.ImageCache;
import com.github.davidmoten.grumpy.wms.ImageWriter;
import com.github.davidmoten.grumpy.wms.ImageWriterDefault;
import com.github.davidmoten.grumpy.wms.Layer;
import com.github.davidmoten.grumpy.wms.LayerManager;
import com.github.davidmoten.grumpy.wms.Layers;
import com.github.davidmoten.grumpy.wms.LayersBuilder;
import com.github.davidmoten.grumpy.wms.WmsRequest;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmsRequestProcessor {
    private static Logger log = LoggerFactory.getLogger(WmsRequestProcessor.class);
    private final ImageCache imageCache;
    private final LayerManager layerManager;
    private final ImageWriter imageWriter;

    public WmsRequestProcessor(Layers layers, ImageCache imageCache, ImageWriter imageWriter) {
        this.imageCache = imageCache;
        this.imageWriter = imageWriter;
        this.layerManager = new LayerManager(layers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeImage(WmsRequest wmsRequest, boolean cacheImage, OutputStream out) throws IOException {
        byte[] result;
        byte[] bytes = cacheImage ? this.imageCache.get(wmsRequest) : null;
        if (bytes == null) {
            log.info("image cache empty");
            BufferedImage image = null;
            image = this.layerManager.getImage(wmsRequest);
            log.info("writing image to memory for layers " + wmsRequest.getLayers());
            ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
            String imageType = wmsRequest.getFormat().substring(wmsRequest.getFormat().indexOf(47) + 1);
            long t = System.currentTimeMillis();
            this.imageWriter.writeImage(image, byteOs, imageType);
            log.info("ImageIoWriteTimeMs=" + (System.currentTimeMillis() - t));
            result = byteOs.toByteArray();
            this.imageCache.put(wmsRequest, result);
        } else {
            result = bytes;
            log.info("obtained image from cache for layers " + wmsRequest.getLayers());
        }
        log.info("writing image to http output stream for layers " + wmsRequest.getLayers());
        out.write(result);
        out.flush();
        log.info("imageSizeK=" + new DecimalFormat("0.000").format((double)result.length / 1000.0) + " for layers " + wmsRequest.getLayers());
    }

    public void writeFeatureInfo(int i, int j, WmsRequest wmsRequest, OutputStream out) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(out);
        Map<String, String> infos = this.layerManager.getInfos(new Date(), wmsRequest, new Point(i, j), wmsRequest.getInfoFormat());
        for (Map.Entry<String, String> entry : infos.entrySet()) {
            log.debug(entry.getKey() + "=" + entry.getValue());
            bos.write(("<p>" + entry.getKey() + "</p>").getBytes());
            bos.write(entry.getValue().getBytes());
        }
        bos.flush();
    }

    public static class Builder {
        private ImageCache imageCache = new ImageCache();
        private Layers layers;
        private final LayersBuilder layersBuilder = LayersBuilder.builder();
        private final List<String> layersToCache = new ArrayList<String>();
        private ImageWriter imageWriter = new ImageWriterDefault();
        private Integer imageCacheSize;

        private Builder() {
        }

        public Builder imageCache(int size) {
            this.imageCacheSize = size;
            return this;
        }

        public Builder addCachedLayer(Layer layer) {
            return this.addCachedLayer(layer.getFeatures().getName(), layer);
        }

        public Builder addCachedLayer(String name, Layer layer) {
            return this.addLayer(name, layer, true);
        }

        public Builder addLayer(Layer layer) {
            return this.addLayer(layer.getFeatures().getName(), layer);
        }

        public Builder addLayer(String name, Layer layer) {
            return this.addLayer(name, layer, false);
        }

        public Builder addLayer(String name, Layer layer, boolean cache) {
            this.layersBuilder.add(name, layer);
            if (cache) {
                this.layersToCache.add(name);
            }
            return this;
        }

        public Builder layers(Layers layers) {
            this.layers = layers;
            return this;
        }

        public Builder imageWriter(ImageWriter imageWriter) {
            this.imageWriter = imageWriter;
            return this;
        }

        public WmsRequestProcessor build() {
            if (this.imageCacheSize != null) {
                this.imageCache = new ImageCache(this.imageCacheSize);
            }
            for (String layer : this.layersToCache) {
                this.imageCache.add(layer);
            }
            if (this.layers == null) {
                this.layers = this.layersBuilder.build();
            }
            return new WmsRequestProcessor(this.layers, this.imageCache, this.imageWriter);
        }
    }
}

