/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.grumpy.wms;

import com.github.davidmoten.grumpy.wms.WmsRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCache {
    private static Logger log = LoggerFactory.getLogger(ImageCache.class);
    private static int DEFAULT_SIZE = 250;
    private volatile List<String> keys = new ArrayList<String>();
    private volatile Set<String> layers = new HashSet<String>();
    private volatile Map<String, byte[]> cache = new ConcurrentHashMap<String, byte[]>();
    private final int maxSize;

    public ImageCache() {
        this(DEFAULT_SIZE);
    }

    public ImageCache(int size) {
        this.maxSize = size;
    }

    public static ImageCache create(int size) {
        return new ImageCache(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String layerName) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            log.info("clearing cache for layer " + layerName);
            for (String key : this.cache.keySet()) {
                if (!key.contains(layerName)) continue;
                this.remove(key);
            }
        }
    }

    private void remove(String key) {
        this.cache.remove(key);
        log.info("removed cache entry " + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(String layerName, boolean enabled) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            if (enabled) {
                this.layers.add(layerName);
            } else {
                this.layers.remove(layerName);
            }
        }
    }

    private static String getKey(WmsRequest request) {
        StringBuffer s = new StringBuffer();
        for (String name : request.getParameterNames()) {
            if (name.startsWith("_")) continue;
            ImageCache.add(s, name, request.getParam(name));
        }
        return s.toString();
    }

    private static void add(StringBuffer s, String name, Object value) {
        s.append(name);
        s.append("=");
        s.append(String.valueOf(value));
        s.append(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(WmsRequest request) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            log.info("cache size=" + this.cache.size());
            return this.cache.get(ImageCache.getKey(request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(WmsRequest request, byte[] image) {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            String key = ImageCache.getKey(request);
            this.keys.remove(key);
            this.keys.add(key);
            if (this.keys.size() > this.maxSize) {
                this.remove(this.keys.get(0));
            }
            if (this.maxSize > 0 && this.layers.containsAll(request.getLayers())) {
                this.cache.put(key, image);
                log.info("cached image with key=" + key);
            }
        }
    }

    public ImageCache add(String layerName) {
        this.setEnabled(layerName, true);
        return this;
    }
}

